% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustGARCH-summary.R
\name{robustGARCH-summary}
\alias{robustGARCH-summary}
\alias{summary.robustGARCH}
\alias{print.robustGARCH}
\alias{plot.robustGARCH}
\alias{coef.robustGARCH}
\alias{aef}
\title{Summary for robustGARCH class}
\usage{
\method{summary}{robustGARCH}(object, digits = 3, ...)

\method{print}{robustGARCH}(x, digits = 3, ...)

\method{plot}{robustGARCH}(
  x,
  digits = 3,
  estimation_pos = "topleft",
  line_name_pos = "topright",
  par_ = par(no.readonly = TRUE),
  pctReturn_ = TRUE,
  abs_ = TRUE,
  original_ = FALSE,
  main_name = "Conditional Volatility (vs |pctReturns(\%)|)",
  ...
)

\method{coef}{robustGARCH}(object, ...)

aef(fit, nu = 5)
}
\arguments{
\item{object}{Same as fit, for summary.robustGARCH}

\item{digits}{the number of digits for print and plot, default is 3.}

\item{...}{# to be written}

\item{x}{Same as fit, for plot.robustGARCH and print.robustGARCH}

\item{estimation_pos}{string that determines the legend position that specifies gamma, alpha, beta estimations. Choice of "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center". Default is "topleft".}

\item{line_name_pos}{string that determines the legend position that specifies the names of lines in the plot. Choice of "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center". Default is "topright".}

\item{par_}{graphical parameters that can be set, which is in the form of par(...). The default is par(no.readonly = TRUE).}

\item{pctReturn_}{a logical argument. IF TRUE, the plot function will plot the returns in percentage instead of original. Default is TRUE.}

\item{abs_}{a logical argument, when TRUE, the plot function will plot abs(returns) with conditional standard deviation instead of returns, default to TRUE.}

\item{original_}{a logical argument. If TRUE, the original return will be plotted. Default is FALSE}

\item{main_name}{the title of the plot, default is "Conditional SD (vs returns)"}

\item{fit}{A robustGARCH fit object of class \code{\link{robGarch}}}

\item{nu}{degrees of freedom in a Student's t-distribution.}
}
\value{
A list of class \code{"summary.robustGARCH"} containing:
\item{method}{The fitting method used (e.g., "BM", "M", "QML", or "MLE").}
\item{coefficients}{Named vector of parameter estimates.}
\item{loglikelihood}{The value of the objective function at convergence.}
\item{converged}{Logical; indicates whether the optimizer converged successfully.}
}
\description{
Summarizes the results of a robust GARCH(1,1) model fit by extracting key model components.
}
\examples{
if (requireNamespace("PCRA", quietly = TRUE)) {
  library(robustGarch)
  
  ret <- PCRA::retOFG
  ret <- ret$RET
  
  (robFitBM <- robGarch(ret, fitMethod = "BM"))
  
  sum(robFitBM$fitted_pars[2:3])
  summary(robFitBM)
  print(robFitBM)
  plot(robFitBM)
  coef(robFitBM)
} else {
  message("Run install.packages('PCRA') to run this example.")
}

}
