% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{suptest}
\alias{suptest}
\title{Supremum proportion test across different cut-offs}
\usage{
suptest(robust2sls_object, alpha, iteration, p = c(0.9, 0.95, 0.99), R = 50000)
}
\arguments{
\item{robust2sls_object}{A list of \code{"robust2sls"} objects.}

\item{alpha}{A numeric value between 0 and 1 representing the significance
level of the test.}

\item{iteration}{An integer >= 0 or the character "convergence" that
determines which iteration is used for the test.}

\item{p}{A numeric vector of probabilities with values in [0,1] for which the
corresponding quantiles are calculated.}

\item{R}{An integer specifying the number of replications for simulating the
distribution of the test statistic.}
}
\value{
\code{suptest()} returns a data frame with one row storing the
iteration that was tested, the value of the test statistic, the corresponding
p-value, the significance level, and whether the null hypothesis is rejected.
The data frame also contains two named attributes. The first attribute is
named \code{"gammas"} and records which gammas determining the different
cut-offs were used in the scaling sup test. The second attribute is named
\code{"critical"} and records the critical values corresponding to the
different quantiles in the limiting distribution that were specified in
\code{p}.
}
\description{
\code{suptest()} uses the estimations across several cut-offs to test whether
the supremum/maximum of the deviations between sample and population FODR
differs significantly from its expected value.
\loadmathjax
\mjdeqn{ \sup_{c} |\sqrt{n}(\widehat{\gamma}_{c} - \gamma_{c})| }{sup_c |sqrt(n)(gammahat_c - gamma_c)|}
}
