% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_beta}
\alias{o_beta}
\title{beta*}
\usage{
o_beta(y, x, con, w = NULL, id = "none", time = "none", delta = 1,
R2max, type, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent treatment variable (i.e., variable of interest; as string).}

\item{con}{Name of related control variables. Provided as string in the format: "w + z +...".}

\item{w}{weights (only for weighted estimations). Warning: For weighted panel models R can report different R-square than Stata, leading deviation between R and Stata results.}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect panel models.}

\item{time}{Name of the time id variable (e.g. year or month; as string). Only applicable for fixed effect panel models.}

\item{delta}{delta for which beta* should be estimated (default is delta = 1).}

\item{R2max}{Maximum R-square for which beta* should be estimated.}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{data}{Dataset.}
}
\value{
Returns tibble object, which includes beta* and various other information.
}
\description{
Estimates beta*, i.e., the bias-adjusted treatment effect (or correlation) (following Oster 2019). The code is based on the psacalc command in Stata.
}
\details{
Estimates beta*, i.e., the bias-adjusted treatment effect (or correlation).
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate beta*
o_beta(y = "mpg",           # dependent variable
       x = "wt",            # independent treatment variable
       con = "hp + qsec",   # related control variables
       delta = 1,           # delta
       R2max = 0.9,         # maximum R-square
       type = "lm",         # model type
       data = data_oster)   # dataset
}
\references{
Oster, E. (2019) Unobservable Selection and Coefficient Stability: Theory and Evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
