% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationEstimators.R
\name{m_est}
\alias{m_est}
\title{M-estimator of location}
\usage{
m_est(
  x,
  psi,
  k = robustbase::.Mpsi.tuning.default(psi),
  tol = 1e-06,
  max.it = 15,
  na.rm = FALSE
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{psi}{kernel used for optimization.
Must be one of \code{"bisquare"}, \code{"hampel"} and \code{"huber"}.
The default is \code{"huber"}.}

\item{k}{tuning parameter(s) for the respective kernel function,
defaults to parameters implemented in \code{\link[robustbase:lmrob.control]{.Mpsi.tuning.default(psi)}}
in the package \href{https://cran.r-project.org/package=robustbase}{robustbase}.}

\item{tol}{tolerance for convergence. The default is 1e-06.}

\item{max.it}{the maximum number of iterations. The default is 15.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}
}
\value{
A named list containing the components:
        \item{est}{estimated mean.}
        \item{var}{estimated variance.}
}
\description{
\code{m_est} calculates an M-estimate of location and its variance
for different psi functions.
}
\details{
To compute the M-estimate, the iterative algorithm described in
\insertCite{MarMarYoh19robu;textual}{robnptests} is used.
The variance is estimated as in \insertCite{Hub81robu;textual}{robnptests}.

If \code{max.it} contains decimal places, it is truncated to an integer
value.
}
\examples{

# Generate random sample
set.seed(108)
x <- rnorm(10)

# Computer Huber's M-estimate
m_est(x, psi = "huber")

}
\references{
\insertRef{MarMarYoh19robu}{robnptests}

\insertRef{Hub81robu}{robnptests}
}
