% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depthgram.R
\name{plot.depthgram}
\alias{plot.depthgram}
\title{Specialized method to plot 'depthgram' objects}
\usage{
\method{plot}{depthgram}(
  x,
  limits = FALSE,
  ids = NULL,
  print = FALSE,
  plot_title = "",
  shorten = TRUE,
  col = NULL,
  pch = 19,
  sp = 2,
  st = 4,
  sa = 10,
  text_labels = "",
  ...
)
}
\arguments{
\item{x}{An object of class \code{depthgram} as output by the
\code{\link{depthgram}} function.}

\item{limits}{A boolean specifying whether the empirical limits for outlier
detection should be drawn. Defaults to \code{FALSE}.}

\item{ids}{A character vector specifying labels for individual observations.
Defaults to \code{NULL}, in which case observations will named by their id
number in order of appearance.}

\item{print}{A boolean specifying whether the graphical output should be
optimized for printed version. Defaults to \code{FALSE}.}

\item{plot_title}{A character string specifying the main title for the plot.
Defaults to \code{""}, which means no title.}

\item{shorten}{A boolean specifying whether labels must be shorten to 15
characters. Defaults to \code{TRUE}.}

\item{col}{Color palette used for the plot. Defaults to \code{NULL}, in which case
a default palette produced by the \code{\link[grDevices]{hcl}} function is
used.}

\item{pch}{Point shape. See \code{\link[plotly]{plotly}} for more details.
Defaults to \code{19}.}

\item{sp}{Point size. See \code{\link[plotly]{plotly}} for more details.
Defaults to \code{2}.}

\item{st}{Label size. See \code{\link[plotly]{plotly}} for more details.
Defaults to \code{4}.}

\item{sa}{Axis title sizes. See \code{\link[plotly]{plotly}} for more
details. Defaults to \code{10}.}

\item{text_labels}{A character vector specifying the labels for the
individuals. It is overridden if \code{limits = TRUE}, for which only outliers
labels are shown. See \code{\link[plotly]{plotly}} for more details.
Defaults to \code{""}.}

\item{...}{Other arguments to be passed to the base \code{\link[base]{plot}}
function. Unused.}
}
\value{
A list with the following items:
\itemize{
\item \code{p}: list with all the interactive (plotly) depthGram plots;
\item \code{out}: outliers detected;
\item \code{colors}: used colors for plotting.
}
}
\description{
This function plots the three 'DepthGram' representations from the output of
the \code{\link{depthgram}} function.
}
\examples{
N <- 50
P <- 50
grid <- seq(0, 1, length.out = P)
Cov <- exp_cov_function(grid, alpha = 0.3, beta = 0.4)

Data <- list()
Data[[1]] <- generate_gauss_fdata(
  N,
  centerline = sin(2 * pi * grid),
  Cov = Cov
)
Data[[2]] <- generate_gauss_fdata(
  N,
  centerline = sin(2 * pi * grid),
  Cov = Cov
)
names <- paste0("id_", 1:nrow(Data[[1]]))
DG <- depthgram(Data, marginal_outliers = TRUE, ids = names)
plot(DG)
}
\references{
Aleman-Gomez, Y., Arribas-Gil, A., Desco, M. Elias-Fernandez, A., and Romo,
J. (2021). "Depthgram: Visualizing Outliers in High Dimensional Functional
Data with application to Task fMRI data exploration".
}
