% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRoads.R
\name{plotRoads}
\alias{plotRoads}
\title{Plot projected roads}
\usage{
plotRoads(sim, mainTitle, subTitle = paste0("Method: ", sim$roadMethod), ...)
}
\arguments{
\item{sim}{\code{sim} list result from \code{projectRoads}}

\item{mainTitle}{character. A title for the plot}

\item{subTitle}{character. A sub title for the plot, by default the \code{roadMethod} is used}

\item{...}{Other arguments passed to raster plot call for the \code{weightRaster}}
}
\value{
Creates a plot using base graphics
}
\description{
Plot the results of \code{\link[=projectRoads]{projectRoads()}}
}
\examples{
CLUSexample <- prepExData(CLUSexample)
prRes <- projectRoads(CLUSexample$landings, CLUSexample$cost, CLUSexample$roads)
if(interactive()){
  plotRoads(prRes, "Title")
}


}
