% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.meta.plot_function.R
\name{series_meta_plot}
\alias{series_meta_plot}
\title{End-user-ready results for a series of pairwise meta-analyses}
\usage{
series_meta_plot(full, meta, drug_names, save_xls)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{meta}{An object of S3 class \code{\link{run_series_meta}}. See 'Value'
in \code{\link{run_series_meta}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl:write_xlsx]{write_xlsx}}
function of the R-package
\href{https://CRAN.R-project.org/package=writexl}{writexl}) at the working
directory of the user. The default is \code{FALSE} (do not export).}
}
\value{
The R console prints the data-frame with the estimated summary effect
  sizes and between-trial standard deviation of comparisons under both
  models. The comparisons have at least two trials. In the case of a
  fixed-effect model, the data-frame is printed without the results on the
  between-trial standard deviation.

  Furthermore, \code{series_meta_plot} exports the data-frame to an 'xlsx'
  file at the working  directory of the user.

  \code{series_meta_plot} returns a panel of two forest plots: (1) a
  forest plot on the posterior median and 95\% credible interval of the summary
  effect size for the observed comparisons from network meta-analysis and the
  corresponding pairwise meta-analyses, and (2) a forest plot on the
  posterior median and 95\% credible interval of the between-trial standard
  deviation for these observed comparisons. The estimated median and 95\%
  credible intervals of the between-trial standard deviation from network
  meta-analysis appear in the forest plot as a solid and two dotted parallel
  blue lines, respectively. The different levels of heterogeneity appear as
  green, yellow, orange, and red rectangles to indicate a low, reasonable,
  fairly high, and fairly extreme heterogeneity, respectively, following the
  classification of Spiegelhalter et al. (2004).
  When a fixed-effect model has been fitted, only the forest plot on the
  estimated summary effect sizes is shown.
}
\description{
Facilitates the comparison of the consistency model
  (via \code{\link{run_model}}) with a series of pairwise meta-analyses
  (via \code{\link{run_series_meta}}) regarding the estimated summary effect
  sizes and between-trial standard deviation for comparisons with at
  least two trials.
}
\details{
\code{series_meta_plot} can be used only for a network of
  interventions. Otherwise, the execution of the function will be stopped and
  an error message will be printed on the R console.

  For a binary outcome, when \code{measure} is "RR" (relative risk) or "RD"
  (risk difference) in \code{\link{run_model}}, \code{series_meta_plot}
  currently presents the results in the odds ratio for being the
  \strong{base-case} effect measure in \code{\link{run_model}} for a binary
  outcome (see also 'Details' in \code{\link{run_model}}).

  The user can detect any inconsistencies in the estimated
  effects from the compared models and explore the gains in precision
  stemming from applying network meta-analysis. Furthermore, the user can
  investigate the plausibility of the common between-trial heterogeneity
  assumption which is typically considered in network meta-analysis.
}
\examples{
data("nma.dogliotti2014")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_dogliotti.rds', package = 'rnmamod'))

# Read results from 'run_series_meta' (using the default arguments)
meta <- readRDS(system.file('extdata/meta_dogliotti.rds',
                package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "aspirin", "aspirin plus clopidogrel",
                  "dabigatran 110 mg", "dabigatran 150 mg", "rivaroxaban",
                  "vitamin K antagonist", "apixaban")

# Plot the results from both models
series_meta_plot(full = res,
                 meta = meta,
                 drug_names = interv_names)

}
\references{
Spiegelhalter DJ, Abrams KR, Myles JP. Bayesian approaches to clinical trials
and health-care evaluation. John Wiley and Sons, Chichester, 2004.
}
\seealso{
\code{\link{run_model}}, \code{\link{run_series_meta}},
  \code{\link[writexl:write_xlsx]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
