% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_rates.R
\name{get_exchangerate_from_interval}
\alias{get_exchangerate_from_interval}
\title{Retrieves the exchange rates from a specific interval.}
\usage{
get_exchangerate_from_interval(table, currency_code, from, to)
}
\arguments{
\item{table}{specifies which from which table the exchange
rate should be fetched.}

\item{currency_code}{code of the currency for which the
exchange rate should be fetched.}

\item{from}{start day of the interval.}

\item{to}{end day of the interval.}
}
\value{
nbp_api_response object containing the exchange rates
from the specified interval.
}
\description{
Retrieves the exchange rates from a specific interval.
}
\details{
As exchange rates are not published on the weekends
fetching values from an interval containing a weekend will
result in a response that omits those days.
}
\examples{
\donttest{
tryCatch(
  {
    ## Fetch the exchange rate table from the past week
    response <- get_exchangerate_tables_from_interval("A", Sys.Date() - 7, Sys.Date())
    ## Preview response content
    response$content
  },
  error = function(e) message(e)
)
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other rates: 
\code{\link{get_current_exchangerate}()},
\code{\link{get_exchangerate_from}()},
\code{\link{get_last_n_exchangerates}()},
\code{\link{get_todays_exchangerate}()}
}
\concept{rates}
