% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCinputFile}
\alias{MzQCinputFile}
\alias{MzQCinputFile-class}
\title{An inputfile within metadata for a run/setQuality}
\description{
An inputfile within metadata for a run/setQuality

An inputfile within metadata for a run/setQuality
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{The name MUST uniquely match to a location (specified below) listed in the mzQC file.}

\item{\code{location}}{Unique file location, REQUIRED to be specified as a URI. The file URI is RECOMMENDED to be publicly accessible.}

\item{\code{fileFormat}}{An MzQCcvParameter with 'accession' and 'name'.}

\item{\code{fileProperties}}{An array of MzQCcvParameter, usually with 'accession', 'name' and 'value'. Recommended are at least two entries:
a) Completion time of the input file (MS:1000747) and b) Checksum of the input file (any child of: MS:1000561 ! data file checksum type).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCinputFile-new}{\code{MzQCinputFile$new()}}
\item \href{#method-MzQCinputFile-isValid}{\code{MzQCinputFile$isValid()}}
\item \href{#method-MzQCinputFile-toJSON}{\code{MzQCinputFile$toJSON()}}
\item \href{#method-MzQCinputFile-fromData}{\code{MzQCinputFile$fromData()}}
\item \href{#method-MzQCinputFile-clone}{\code{MzQCinputFile$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCinputFile-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCinputFile-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCinputFile$new(
  name = NA_character_,
  location = NA_character_,
  fileFormat = MzQCcvParameter$new(),
  fileProperties = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{String value for initialization of field name}

\item{\code{location}}{String value for initialization of field location}

\item{\code{fileFormat}}{Optional MzQCcvParameter value for initialization of field fileFormat}

\item{\code{fileProperties}}{Optional list value for initialization of field fileProperties}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCinputFile-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCinputFile-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCinputFile$isValid(context = "MzQCinputFile")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCinputFile-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCinputFile-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCinputFile$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCinputFile-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCinputFile-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCinputFile$fromData(data, context = "MzQCinputFile")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCinputFile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCinputFile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCinputFile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
