% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{MzQCDateTime}
\alias{MzQCDateTime}
\alias{MzQCDateTime-class}
\title{An mzQC-formatted date+time in ISO8601 format, as required by the mzQC spec doc.}
\description{
An mzQC-formatted date+time in ISO8601 format, as required by the mzQC spec doc.

An mzQC-formatted date+time in ISO8601 format, as required by the mzQC spec doc.
}
\details{
The format is "\%Y-\%m-\%dT\%H:\%M:\%S".
}
\examples{
   dt1 = MzQCDateTime$new("1900-01-01")  ## yields "1900-01-01T00:00:00Z"
   dt2 = MzQCDateTime$new(Sys.time())
   ## test faulty input
   ## errors with 'character string is not in a standard unambiguous format'
   try(MzQCDateTime$new('lala'), silent=TRUE)
   ## test roundtrip conversion from/to JSON
   dt2$fromData(jsonlite::fromJSON(jsonlite::toJSON(dt1)))

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{datetime}}{A correctly formatted date time (use as read-only)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MzQCDateTime-new}{\code{MzQCDateTime$new()}}
\item \href{#method-MzQCDateTime-set}{\code{MzQCDateTime$set()}}
\item \href{#method-MzQCDateTime-isValid}{\code{MzQCDateTime$isValid()}}
\item \href{#method-MzQCDateTime-toJSON}{\code{MzQCDateTime$toJSON()}}
\item \href{#method-MzQCDateTime-fromData}{\code{MzQCDateTime$fromData()}}
\item \href{#method-MzQCDateTime-clone}{\code{MzQCDateTime$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-new"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$new(date = as.character(Sys.time()))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{Optional POSIXct value for initialization of field datetime. Defaults to Sys.time()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-set"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-set}{}}}
\subsection{Method \code{set()}}{
Sets datetime value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$set(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{New date-time}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-isValid"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-isValid}{}}}
\subsection{Method \code{isValid()}}{
Verifies validity of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$isValid(context = "MzQCDateTime")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-toJSON"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-toJSON}{}}}
\subsection{Method \code{toJSON()}}{
Creates JSON file from this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$toJSON(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional parameters for jsonlite:::asJSON()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-fromData"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-fromData}{}}}
\subsection{Method \code{fromData()}}{
Sets data for this object from plain named lists of R objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$fromData(data, context = "MzQCDateTime")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}

\item{\code{context}}{Optional string describing location in mzQC structure that is used for more informative warning texts.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MzQCDateTime-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MzQCDateTime-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MzQCDateTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
