% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_predict_the_test_set.R
\name{rmw_predict_the_test_set}
\alias{rmw_predict_the_test_set}
\title{Functions to use a model to predict the observations within a test set after
\code{rmw_calculate_model}.}
\usage{
rmw_predict_the_test_set(model, df)
}
\arguments{
\item{model}{A ranger model object from \code{rmw_calculate_model}.}

\item{df}{Input data used to calculate \code{model}.}
}
\value{
Tibble.
}
\description{
\code{rmw_predict_the_test_set} uses data withheld from the training of the 
model and therefore can be used for investigating overfitting.
}
\examples{

# Load package
library(dplyr)

# Prepare example data
data_london_prepared <- data_london \%>\% 
  filter(variable == "no2") \%>\% 
  rmw_prepare_data()

# Use the test set for prediction
rmw_predict_the_test_set(
  model_london, 
  df = data_london_prepared
)

# Predict, then produce a hex plot of the predictions
rmw_predict_the_test_set(
  model_london, 
  df = data_london_prepared
) \%>\% 
  rmw_plot_test_prediction()

}
\author{
Stuart K. Grange
}
