% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.rmtfit}
\alias{plot.rmtfit}
\title{Plot the estimated treatment effect curve}
\usage{
\method{plot}{rmtfit}(
  x,
  k = NULL,
  conf = FALSE,
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Follow-up time",
  ylab = "Restricted mean time in favor",
  conf.col = "black",
  conf.lty = 3,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{rmtfit}}.}

\item{k}{If specified, \eqn{\mu_k(\tau)} is plotted; otherwise, \eqn{\mu(\tau)} is plotted.}

\item{conf}{If TRUE, 95\% confidence limits for the target curve are overlaid.}

\item{main}{A main title for the plot}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{A label for the x axis, defaults to a description of x.}

\item{ylab}{A label for the y axis, defaults to a description of y.}

\item{conf.col}{Color for the confidence limits if \code{conf=TRUE}.}

\item{conf.lty}{Line type for the confidence limits if \code{conf=TRUE}.}

\item{...}{Other arguments that can be passed to the underlying \code{plot} method.}
}
\value{No return value, called for side effects.}
\description{
Plot the estimated overall or stage-wise restricted mean times in favor of treatment as a
function of follow-up time.
}
\examples{
# load the colon cancer trial data
library(rmt)
head(colon_lev)
# fit the data
obj=rmtfit(ms(id,time,status)~rx,data=colon_lev)
# plot overal effect mu(tau)
plot(obj)
# set-up plot parameters
oldpar <- par(mfrow = par("mfrow"))
par(mfrow=c(1,2))
# Plot of component-wise RMT in favor of treatment over time
plot(obj,k=2,conf=TRUE,col='red',conf.col='blue', xlab="Follow-up time (years)",
    ylab="RMT in favor of treatment (years)",main="Survival")
plot(obj,k=1,conf=TRUE,col='red',conf.col='blue', xlab="Follow-up time (years)",
    ylab="RMT in favor of treatment (years)",main="Pre-relapse")
par(oldpar)
}
\seealso{
\code{\link{rmtfit}}, \code{\link{summary.rmtfit}}, \code{\link{bouquet}}.
}
\keyword{rmtfit}
