% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackMI.r
\name{stackMI}
\alias{stackMI}
\title{Bayesian Model Fitting and Stacking for Multiple Imputation}
\usage{
stackMI(
  formula,
  fitter,
  xtrans,
  data = NULL,
  n.impute = xtrans$n.impute,
  dtrans = NULL,
  derived = NULL,
  subset = NULL,
  refresh = 0,
  progress = if (refresh > 0) "stan-progress.txt" else "",
  file = NULL,
  ...
)
}
\arguments{
\item{formula}{a model formula}

\item{fitter}{a Bayesian fitter}

\item{xtrans}{an object created by \code{transcan}, \code{\link[Hmisc]{aregImpute}}, or \code{\link[mice]{mice}}}

\item{data}{data frame}

\item{n.impute}{number of imputations to run, default is the number saved in \code{xtrans}}

\item{dtrans}{see \code{Hmisc::fit.mult.impute}}

\item{derived}{see \code{Hmisc::fit.mult.impute}}

\item{subset}{an integer or logical vector specifying the subset of observations to fit}

\item{refresh}{see \link[rstan:stanmodel-method-sampling]{rstan::sampling}.  The default is 0, indicating that no progress notes are output.  If \code{refresh > 0} and \code{progress} is not \code{''}, progress output will be appended to file \code{progress}.  The default file name is \code{'stan-progress.txt'}.}

\item{progress}{see \code{refresh}.  Defaults to \code{''} if \code{refresh = 0}.  Note: If running interactively but not under RStudio, \code{rstan} will open a browser window for monitoring progress.}

\item{file}{optional file name in which to store results in RDS format.  If \code{file} is given and it already exists, and none of the arguments to \code{stackMI} have changed since that fit, the fit object from \code{file} is immediately returned.  So if the model, data, and imputations have not changed nothing needs to be computed.}

\item{...}{arguments passed to \code{fitter}}
}
\value{
an \code{rmsb} fit object with expanded posterior draws and diagnostics
}
\description{
Runs an \code{rmsb} package Bayesian fitting function such as \code{blrm} separately for each completed dataset given a multiple imputation result such as one produced by \code{Hmisc::aregImpute}.  Stacks the posterior draws and diagnostics across all imputations, and computes parameter summaries on the stacked posterior draws.
}
\author{
Frank Harrell
}
