% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/nsga.R, R/nsga2.R, R/nsga3.R
\docType{methods}
\name{progress}
\alias{progress}
\alias{progress,nsga-method}
\alias{progress,nsga,nsga-method}
\alias{progress,nsga1-method}
\alias{progress,nsga2-method}
\alias{progress,nsga3-method}
\title{Methods for Function 'progress' in Package 'rmoo'}
\usage{
progress(object, ...)

\S4method{progress}{nsga}(object, ...)

\S4method{progress}{nsga1}(object, ...)

\S4method{progress}{nsga2}(object, ...)

\S4method{progress}{nsga3}(object, ...)
}
\arguments{
\item{object}{Objects of either class \linkS4class{nsga1},
\linkS4class{nsga2},  or \linkS4class{nsga3}.}

\item{...}{other arguments passed on to methods. Passing \code{"reference_dirs"}
as arguments will evaluate the performance metrics Hypervolumen,
Generational Distance, and Inverse Generational Distance.}
}
\value{
A list of length equal to the number of iterations, where the progress made during execution is saved.
}
\description{
Method used to save the progress of the evaluation results, similar to the
summary method. Passing additional arguments to the progress method evaluates
performance metrics per iteration. This method cannot be called outside of
rmoo execution.
}
\examples{
# Where 'out' is an object of class nsga1, nsga2, or nsga3, and callArgs are
# the additional arguments passed when calling the rmoo function, for the
# evaluation of performance metrics, reference points are expected to be passed
# as an argument to reference_dirs.
#
# progress(object, callArgs)
#

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
