% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/nsga.R, R/nsga2.R, R/nsga3.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,nsga,missing-method}
\alias{plot,nsga,missing}
\alias{plot,nsga1,missing-method}
\alias{plot,nsga1-method}
\alias{plot,nsga2,missing-method}
\alias{plot,nsga2-method}
\alias{plot,nsga3,missing-method}
\alias{plot,nsga3-method}
\title{Methods for Function 'plot' in Package 'rmoo'}
\usage{
plot(x, y, ...)

\S4method{plot}{nsga,missing}(x, y = "missing", type = c("scatter", "pcp", "heatmap", "polar"), ...)

\S4method{plot}{nsga1,missing}(x, y = "missing", type = c("scatter", "pcp", "heatmap", "polar"), ...)

\S4method{plot}{nsga2,missing}(x, y = "missing", type = c("scatter", "pcp", "heatmap", "polar"), ...)

\S4method{plot}{nsga3,missing}(x, y = "missing", type = c("scatter", "pcp", "heatmap", "polar"), ...)
}
\arguments{
\item{x, y}{Objects of either class \linkS4class{nsga1},
\linkS4class{nsga2},  or \linkS4class{nsga3}.}

\item{...}{other arguments passed on to methods
\describe{
\item{"optimal"}{An argument passed to the "scatter" plot. A matrix of
dimension equal to the fitness with which they are compared. This value can
only be compared in 2 and 3 dimensional "scatter" plots.}
\item{"individual"}{An argument passed to the "heatmap" and "polar" plots.
A vector that represents the fitness of the individuals to be displayed.}
}}

\item{type}{Type of graph to draw, the graphs can be of the type "scatter",
"pcp", "heatmap", or "polar"}
}
\value{
A graph of the evaluated type.
}
\description{
Method used to visualize the fitness of the individuals during the execution
of the algorithms.
}
\details{
The following plots are available:

\itemize{
\item{}{"Scatter Plot"}
\item{}{"Parallel Coordinate Plot"}
\item{}{"Heat Map"}
\item{}{"Polar Coordinate"}
}
}
\examples{
# Where 'out' is an object of class nsga1, nsga2, or nsga3.
# The plot method will by default plot a scatter plot.
#
# plot(out)
#
# The Parallel Coordinate Plot will be plotted if "pcp" is passed as a parameter to "type".
#
# plot(out, type="pcp")
#
# A heat map plot will be plotted if "heatmap" is passed as a parameter to "type"
# and a vector with the individuals to plot to "individual"
#
# plot(out, type = "heatmap", individual = c(1:5))
#
# A polar coordinate plot will be plotted if "polar" is passed as a parameter to "type"
# and a vector with the individuals to plot to "individual"
#
# plot(out, type = "polar", individual = c(1:5))

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
