% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfanova.R
\name{summary.rmfanova}
\alias{summary.rmfanova}
\title{Print "rmfanova" object}
\usage{
\method{summary}{rmfanova}(object, ...)
}
\arguments{
\item{object}{a "rmfanova" object.}

\item{...}{integer indicating the number of decimal places to be used to present the numerical results.
It can be named \code{digits} as in the \code{round()} function (see examples).}
}
\value{
No return value, called for side effects.
}
\description{
Prints the summary of the repeated measures functional analysis of variance.
}
\details{
The function prints out the information about the number of samples \eqn{\ell},
number of observations \eqn{n}, number of design time points \eqn{p},
adjustment method for pairwise comparison tests (if \eqn{\ell>2}), test statistics,
and p-values of tests performed by the \code{rmfanova()} function.
}
\examples{
# Some of the examples may run some time.
# preparation of the DTI data set, for details see Kurylo and Smaga (2023)
library(refund)
data(DTI)
# MS patients
DTI_ms <- DTI[DTI$case == 1, ]
miss_data <- c()
for (i in 1:340) if (any(is.na(DTI_ms$cca[i, ]))) miss_data <- c(miss_data, i)
DTI_ms <- DTI_ms[-miss_data, ]
DTI_ms_2 <- DTI_ms[DTI_ms$Nscans == 4, ]
xx <- vector("list", 4)
for (i in 1:4) {
  xx[[i]] <- DTI_ms_2$cca[DTI_ms_2$visit == i, ]
}
xx[[1]] <- xx[[1]][-14, ]
xx[[3]] <- xx[[3]][-14, ]
yy <- xx
for (i in seq_len(4)) yy[[i]] <- yy[[i]][1:17, ]
\donttest{
# testing without parallel computing and multiple generation of Gaussian processes
res <- rmfanova(yy)
summary(res, digits = 3)}

}
