% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{fmls}
\alias{fmls}
\alias{is_fmls}
\alias{key_terms}
\title{Vectorized formulas}
\usage{
fmls(
  x = unspecified(),
  pattern = c("direct", "sequential", "parallel", "fundamental"),
  ...
)

is_fmls(x)

key_terms(x)
}
\arguments{
\item{x}{Objects of the following types can be used as inputs
\itemize{
\item \code{tm}
\item \code{formula}
}}

\item{pattern}{A \code{character} from the following choices for pattern
expansion. This is how the formula will be expanded, and decides how the
covariates will incorporated. See the details for further explanation.
\itemize{
\item direct: the covariates will all be included in each formula
\item sequential: the covariates will be added sequentially, one by one, or by groups, as indicated
\item parallel: the covariates or groups of covariates will be placed in parallel
\item fundamental: every formula will be decomposed to a single outcome and predictor in an atomic fashion
}}

\item{...}{Arguments to be passed to or from other methods}
}
\value{
An object of class \code{fmls}
}
\description{
This function defines a modified \code{formula} class that has been
vectorized. The \code{fmls} serves as a set of instructions or a \emph{script} for the
formula and its tm. It expands upon the functionality of formulas,
allowing for additional descriptions and relationships to exist between the
tm.
}
\details{
This is not meant to supersede a \code{\link[stats:formula]{stats::formula()}} object, but provide a
series of relationships that can be helpful in causal modeling. All \code{fmls}
can be converted to a traditional \code{formula} with ease. The base for this
object is built on the \code{\link[=tm]{tm()}} object.
}
\section{Patterns}{
The expansion pattern allows for instructions on how the covariates should be
included in different formulas. Below, assuming that \emph{x1}, \emph{x2}, and \emph{x3} are
covariates...

\deqn{y = x1 + x2 + x3}

\strong{Direct}:

\deqn{y = x1 + x2 + x3}

\strong{Seqential}:

\deqn{y = x1}
\deqn{y = x1 + x2}
\deqn{y = x1 + x2 + x3}

\strong{Parallel}:

\deqn{y = x1}
\deqn{y = x2}
\deqn{y = x3}
}

\section{Roles}{
Specific roles the variable plays within the formula. These are of particular
importance, as they serve as special terms that can effect how a formula is
interpreted.\tabular{lll}{
   Role \tab Shortcut \tab Description \cr
   outcome \tab \code{.o(...)} \tab \strong{outcome} ~ exposure \cr
   exposure \tab \code{.x(...)} \tab outcome ~ \strong{exposure} \cr
   predictor \tab \code{.p(...)} \tab outcome ~ exposure + \strong{predictor} \cr
   confounder \tab \code{.c(...)} \tab outcome + exposure ~ \strong{confounder} \cr
   mediator \tab \code{.m(...)} \tab outcome \strong{mediator} exposure \cr
   interaction \tab \code{.i(...)} \tab outcome ~ exposure * \strong{interaction} \cr
   strata \tab \code{.s(...)} \tab outcome ~ exposure / \strong{strata} \cr
   group \tab \code{.g(...)} \tab outcome ~ exposure + \strong{group} \cr
   \emph{unknown} \tab \code{-} \tab not yet assigned \cr
}


Formulas can be condensed by applying their specific role to individual runes
as a function/wrapper. For example, \code{y ~ .x(x1) + x2 + x3}. This would
signify that \code{x1} has the specific role of an \emph{exposure}.

Grouped variables are slightly different in that they are placed together in
a hierarchy or tier. To indicate the group and the tier, the shortcut can
have an \code{integer} following the \code{.g}. If no number is given, then it is
assumed they are all on the same tier. Ex: \code{y ~ x1 + .g1(x2) + .g1(x3)}

\strong{Warning}: Only a single shortcut can be applied to a variable within a
formula directly.
}

\section{Pluralized Labeling Arguments}{
For a single argument, e.g. for the \code{tm.formula()} method, such as to
identify variable \strong{X} as an exposure, a \code{formula} should be given with the
term of interest on the \emph{LHS}, and the description or instruction on the
\emph{RHS}. This would look like \code{role = "exposure" ~ X}.

For the arguments that would be dispatched for objects that are plural, e.g.
containing multiple terms, each \code{formula()} should be placed within a
\code{list()}. For example, the \strong{role} argument would be written:

\code{role = list(X ~ "exposure", M ~ "mediator", C ~ "confounder")}

Further implementation details can be seen in the implementation of
\code{\link[=labeled_formulas_to_named_list]{labeled_formulas_to_named_list()}}.
}

