/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NonSparseToSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    static final long serialVersionUID = 4694489111366063852L;

    public String globalInfo() {
        return "An instance filter that converts all incoming instances into sparse format.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        SparseInstance inst = new SparseInstance(instance);
        inst.setDataset(instance.dataset());
        this.push(inst);
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5548 $");
    }

    public static void main(String[] argv) {
        NonSparseToSparse.runFilter(new NonSparseToSparse(), argv);
    }
}

