% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_environments.R
\name{def_environments}
\alias{def_environments}
\title{Define environments}
\usage{
def_environments(
  environ = NULL,
  environ_type = NULL,
  environ_class = NULL,
  environ_id = NULL
)
}
\arguments{
\item{environ}{\code{character}. The name of a specific environment (e.g.,
"reef") to return a definition for.}

\item{environ_type}{\code{character}. The name of a type of environment
(e.g., "carbonate") to return a definition for.}

\item{environ_class}{\code{character}. The name of a class of environment
(e.g., "marine") to return a definition for.}

\item{environ_id}{\code{integer}. The unique identification number of the
desired environment to return a definition for.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{environ_id}: The unique identification number of the
environment.
\item \code{name}: The name of the environment.
\item \code{type}: Environment type, less inclusive than class.
\item \code{class}: Environment class, more inclusive than type.
\item \code{color}: Recommended coloring for environment, based on the
dominant lithology.
\item \code{t_units}: The total number of Macrostrat units that are
partially, or entirely, composed of the environment.
}
}
\description{
A function to retrieve the definitions for one or more
environments in the Macrostrat database. By default, all environment
definitions are returned.
}
\section{Developer(s)}{

Christopher D. Dean
}

\section{Reviewer(s)}{

Lewis A. Jones
}

\examples{
\donttest{
# Return all environment definitions
ex1 <- def_environments()
# Return subsets of environment definitions
ex2 <- def_environments(environ = "reef")
ex3 <- def_environments(environ_type = "carbonate")
ex4 <- def_environments(environ_class = "marine")
}
}
\seealso{
Geologic features and attributes:
\code{\link{def_econs}()},
\code{\link{def_grain_sizes}()},
\code{\link{def_lithologies}()},
\code{\link{def_lithology_att}()},
\code{\link{def_measurements}()},
\code{\link{def_minerals}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
