% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpr.R
\name{rpr}
\alias{rpr}
\title{Cluster and Subcluster effects}
\usage{
rpr(f, resd, data, rprpair = "hl-disp")
}
\arguments{
\item{f}{A model formula which specifices the random effects (see example)}

\item{resd}{The residuals from the fitted model}

\item{data}{The data the model was fitted on}

\item{rprpair}{Character string indicating the location and scale parameters
to use. Default to "hl-disp", but may also be "med-mad". See Bilgic (2012).}
}
\value{
\item{siga2}{ Variance from cluster }
  \item{sigw2}{ Variance from subcluster }
  \item{sigmae2}{ Remaining variance not accounted for by variance of cluster and subcluster }
}
\description{
Partitions model residuals into cluster and subcluster effects using RPP
algorithm.
}
\examples{

# Load school data
data(schools)

# Fit fixed effects model with lmr
lmr.fit = lmr(y ~ age + sex, data=schools)

# Three level design
# Partition residuals into school and region effects with rpp algorithm
rpr(y ~ age + sex + (1 | school) + (1 | school:region), lmr.fit$ehat, schools)

# Two level design
# Estimate variance in residuals from school
rpr(y ~ age + sex + (1 | school), lmr.fit$ehat, schools)

}
\references{
Y. K. Bilgic. Rank-based estimation and prediction for mixed
effects models in nested designs. 2012. URL
http://scholarworks.wmich.edu/dissertations/40. Dissertation.
}
\seealso{
rprmeddis, dispvar
}
\author{
J. W. McKean and Y. K. Bilgic
}
