% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbrwts_gr.r
\name{hbrwts_gr}
\alias{hbrwts_gr}
\title{HBR Weight}
\usage{
hbrwts_gr(xmat, y, percent = 0.95, intest = ltsreg(xmat, y)$coef)
}
\arguments{
\item{xmat}{Design matrix, pxn, without intercept.}

\item{y}{Response vector in nx1.}

\item{percent}{This is 0.95.}

\item{intest}{This is obtained from myltsreg(xmat, y)$coef}
}
\description{
Calculates hbr weights for the GEER method. This turns a vector of weights
for a vector of errors. Used to make factor space more robust, up to 50\%
breakdown. See HM (2012) and Terpstra and McKean (2005) for details. The ww
package produces this weights as well.
}
\details{
The ww package explains how it is obtained.
}
\references{
T. P. Hettmansperger and J. W. McKean. Robust Nonparametric
Statistical Methods. Chapman Hall, 2012.

J. T. Terpstra and J. W. McKean. Rank-based analysis of linear models using
R. Journal of Statistical Software, 14(7):1 - 26, 7 2005. ISSN 1548-7660.
URL http://www.jstatsoft.org/v14/i07.
}
\seealso{
GEER_est
}
\author{
J. W. McKean
}
