% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxflow.R
\name{NetworkCirculation}
\alias{NetworkCirculation}
\title{Solver for Network Circulation}
\usage{
NetworkCirculation(
  arcSources,
  arcTargets,
  arcLowerBound,
  arcUpperBound,
  nodeSupplies,
  numNodes,
  algorithm = "Circulation"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcLowerBound}{Vector corresponding to the lower-bound capacities of
nodes of a graph's edges}

\item{arcUpperBound}{Vector corresponding to the upper-bound capacities of
nodes of a graph's edges}

\item{nodeSupplies}{Vector corresponding to the supplies of each node of the
graph.}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithminclude "Circulation". "Circulation" is
the default.}
}
\value{
A named list containing two entries: 1) "flows": a vector
  corresponding to the flows of arcs in the graph, and 2) "barriers": a
  vector of the graph's barrier nodes.
}
\description{
Finds the solution to the network circulation problem via the push-relabel
circulation algorithm.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00078.html}.
}
