% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{layerLegend}
\alias{layerLegend}
\title{Data layer legend}
\usage{
layerLegend(
  style,
  labels = "",
  title = NULL,
  position = "bottomright",
  png = NULL,
  size = 5,
  png.width = NULL,
  png.height = NULL,
  stroke.col = 1,
  stroke.lwd = 1,
  stroke.lty = -1,
  stroke.alpha = 1,
  fill.col = 2,
  fill.alpha = 0.5,
  cells.range = c(1, 10),
  cells.col = heat.colors(12),
  cells.alpha = 1
)
}
\arguments{
\item{style}{the style of legend to generate.
Can be one of "\code{points}", "\code{lines}", "\code{polygons}", "\code{icons}", "\code{gradient}".}

\item{labels}{a vector to label each element of the legend.}

\item{title}{a title which will appear above the legend.
If \code{NULL} (default), it will inherit the name of the data layer during the compilation of the map.
If \code{NA}, the legend will appear without title.}

\item{position}{a character string indicating where should the legend be displayed.
This must be one of "\code{topleft}", "\code{topright}", "\code{bottomleft}", "\code{bottomright}", "\code{none}"}

\item{png}{character vector giving the paths for the PNG icons. If \code{NULL} (default), circles are drawn.}

\item{size}{a numerical vector giving the size of points (radius in pixels).}

\item{png.width, png.height}{numerical vectors giving the PNG icons dimensions on the map (in pixels).}

\item{stroke.col}{a vector of any of the three kinds of \R color specifications to set strokes color.}

\item{stroke.lwd}{a numerical vector to set strokes width.}

\item{stroke.lty}{a character vector that defines the strokes dash patterns (See Details).}

\item{stroke.alpha}{a vector of numeric values in \eqn{[0, 1]} setting strokes opacity.}

\item{fill.col}{a vector of any of the three kinds of \R color specifications to set fill colors.}

\item{fill.alpha}{a vector of numeric values in \eqn{[0, 1]} setting fill opacity.}

\item{cells.range}{range of gradient values.}

\item{cells.col}{a vector of any of the three kinds of \R color specifications giving the colors of the gradient.}

\item{cells.alpha}{a vector of numeric values in \eqn{[0, 1]} setting the gradient opacity.}
}
\value{
an object \code{layerlegend} which can be passed to an \code{spLayer*} function through the \code{legend} argument.
}
\description{
This function creates a legend object that can be attached to a data layer.
}
