% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{Summary.rle}
\alias{Summary.rle}
\title{Summary methods for \code{\link{rle}} objects.}
\usage{
\method{Summary}{rle}(..., na.rm)
}
\arguments{
\item{...}{\code{\link{rle}} objects or objects that can be coerced to \code{rle}.}

\item{na.rm}{Whether the missing values should be ignored (\code{TRUE}) or propagated (\code{FALSE}).}
}
\value{
In every supported case, the call should produce the same
result as what would have resulted had the call been applied to
the original (uncompressed) vector. (At no point in the
calculation is the uncompressed vector actually constructed, of
course.) The exception is that if \code{values} are of class
\code{integer}, the result will nonetheless always be upcast to
\code{numeric} to avert overflows. This behaviour may change in the
future.
}
\description{
Summarisation functions for vectors described in \link{Summary} are implemented for \code{\link{rle}} objects.
}
\details{
Supported functions include all elements of the S3
\link{Summary} group. As of this writing, functions supported include
(from R help) \code{all}, \code{any}, \code{max}, \code{min}, \code{prod}, \code{range}, and
\code{sum}.
}
\examples{

x <- rle(as.logical(rbinom(20,1,.7)))
y <- rle(as.logical(rbinom(20,1,.3)))

stopifnot(isTRUE(all.equal(any(x, y),any(inverse.rle(x), inverse.rle(y)))))
stopifnot(isTRUE(all.equal(any(y),any(inverse.rle(y)))))

stopifnot(isTRUE(all.equal(sum(inverse.rle(x),inverse.rle(y)),sum(x,y))))
stopifnot(isTRUE(all.equal(sum(inverse.rle(y)),sum(y))))

y$values[2:3] <- NA
stopifnot(isTRUE(all.equal(sum(inverse.rle(y), na.rm=TRUE),sum(y, na.rm=TRUE))))
stopifnot(isTRUE(all.equal(sum(inverse.rle(y), na.rm=FALSE),sum(y, na.rm=FALSE))))

}
