% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{UDF.Kernel}
\alias{UDF.Kernel}
\title{User Defined Function (UDF) Kernel}
\usage{
UDF.Kernel(lengthscale, kernel.function)
}
\arguments{
\item{lengthscale}{a vector for the positive length scale parameters}

\item{kernel.function}{user defined kernel function}
}
\value{
A User Defined Function (UDF) Kernel Class Object.
}
\description{
This function specifies a kernel with the user defined R function.
}
\details{
The User Defined Function (UDF) kernel is given by
\deqn{k(r) = f(r^2)}{k(r) = f(r^2)}
where \eqn{f}{f} is the user defined kernel function that takes \eqn{r^2}{r^2} as input, 
where \deqn{r(x,x^{\prime})=\sqrt{\sum_{i=1}^{p}\left(\frac{x_{i}-x_{i}^{\prime}}{l_{i}}\right)^2},}{r(x,x') = sqrt(sum_{i=1}^{p} [(x_i - x'_i) / l_i]^2),} 
is the euclidean distance between \eqn{x}{x} and \eqn{x^{\prime}}{x'} weighted by
the length scale parameters \eqn{l_{i}}{l_i}'s.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

kernel.function <- function(sqdist) {return (exp(-sqrt(sqdist)))} 

# approach 1
kernel <- UDF.Kernel(lengthscale, kernel.function=kernel.function)
Evaluate.Kernel(kernel, X)

# approach 2
kernel <- Get.Kernel(lengthscale, type="UDF", 
                     parameters=list(kernel.function=kernel.function))
Evaluate.Kernel(kernel, X) 

}
\references{
Duvenaud, D. (2014). \emph{The kernel cookbook: Advice on covariance functions}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.
}
\seealso{
\link{MultiplicativeUDF.Kernel}, \link{Get.Kernel}, \link{Evaluate.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
