% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{j_flatten}
\alias{j_flatten}
\alias{j_find_values}
\alias{j_find_values_grep}
\alias{j_find_keys}
\alias{j_find_keys_grep}
\alias{flatten_NDJSON}
\title{Flatten and find keys or values in JSON or NDJSON documents}
\usage{
j_flatten(
  data,
  object_names = "asis",
  as = "string",
  ...,
  n_records = Inf,
  verbose = FALSE,
  data_type = j_data_type(data),
  path_type = "JSONpointer"
)

j_find_values(
  data,
  values,
  object_names = "asis",
  as = "R",
  ...,
  n_records = Inf,
  verbose = FALSE,
  data_type = j_data_type(data),
  path_type = "JSONpointer"
)

j_find_values_grep(
  data,
  pattern,
  object_names = "asis",
  as = "R",
  ...,
  grep_args = list(),
  n_records = Inf,
  verbose = FALSE,
  data_type = j_data_type(data),
  path_type = "JSONpointer"
)

j_find_keys(
  data,
  keys,
  object_names = "asis",
  as = "R",
  ...,
  n_records = Inf,
  verbose = FALSE,
  data_type = j_data_type(data),
  path_type = "JSONpointer"
)

j_find_keys_grep(
  data,
  pattern,
  object_names = "asis",
  as = "R",
  ...,
  grep_args = list(),
  n_records = Inf,
  verbose = FALSE,
  data_type = j_data_type(data),
  path_type = "JSONpointer"
)
}
\arguments{
\item{data}{a character() JSON string or NDJSON records, or the
name of a file or URL containing JSON or NDJSON, or an \emph{R}
object parsed to a JSON string using \code{jsonlite::toJSON()}.}

\item{object_names}{character(1) order \code{data} object elements
\code{"asis"} (default) or \code{"sort"} before filtering on \code{path}.}

\item{as}{character(1) describing the return type.  For
\code{j_flatten()}, either "string" or "R". For other functions on
this page, one of "R", "data.frame", or "tibble".}

\item{...}{passed to \code{jsonlite::toJSON} when \code{data} is an \emph{R} object.}

\item{n_records}{numeric(1) maximum number of NDJSON records parsed.}

\item{verbose}{logical(1) report progress when parsing large NDJSON
files.}

\item{data_type}{character(1) type of \code{data}; one of \code{"json"},
\code{"ndjson"}, or a value returned by \code{j_data_type()}.}

\item{path_type}{character(1) type of 'path' to be returned; one of
'"JSONpointer"', '"JSONpath"'; '"JMESpath"' is not supported.}

\item{values}{vector of one or more values to be matched exactly to
values in the JSON document.}

\item{pattern}{character(1) regular expression to match values or
paths.}

\item{grep_args}{list() additional arguments passed to \code{grepl()}
when searching on values or paths.}

\item{keys}{character() vector of one or more keys to be matched
exactly to path elements.}
}
\value{
\code{j_flatten(as = "string")} (default) returns a JSON string
representation of the flattened document, i.e., an object with keys
the JSONpointer paths and values the value at the corresponding
path in the original document.

\code{j_flatten(as = "R")} returns a named list, where \code{names()} are the
JSONpointer paths to each element in the JSON document and list
elements are the corresponding values.

\code{j_find_values()} and \code{j_find_values_grep()} return a list
with names as JSONpointer paths and list elements the matching
values, or a \code{data.frame} or \code{tibble} with columns \code{path} and
\code{value}. Values are coerced to a common type when \code{as} is
\code{data.frame} or \code{tibble}.

\code{j_find_keys()} and \code{j_find_keys_grep()} returns a list,
data.frame, or tibble similar to \code{j_find_values()} and
\code{j_find_values_grep()}.

For NDJSON documents, the result is a vector paralleling
the NDJSON document, with \code{j_flatten()} applied to each element
of the NDJSON document.
}
\description{
\code{j_flatten()} transforms a JSON document into a list
where names are JSONpointer 'paths' and elements are the
corresponding 'values' from the JSON document.

\code{j_find_values()} finds paths to exactly matching
values.

\code{j_find_values_grep()} finds paths to values matching
a regular expression.

\code{j_find_keys()} finds paths to exactly matching keys.

\code{j_find_keys_grep()} finds paths to keys matching a
regular expression.

For NDJSON documents, the result is either a character
vector (for \code{as = "string"}) or list of \emph{R} objects, one
element for each NDJSON record.
}
\details{
Functions documented on this page expand \code{data} into all
path / value pairs. This is not suitable for very large JSON
documents.

For \code{j_find_keys()}, the \code{key} must exactly match one or
more consecutive keys in the JSONpointer path returned by
\code{j_flatten()}.

For \code{j_find_keys_grep()}, the \code{key} can define a pattern
that spans across JSONpointer or JSONpath elements.
}
\examples{
json <- '{
    "discards": {
        "1000": "Record does not exist",
        "1004": "Queue limit exceeded",
        "1010": "Discarding timed-out partial msg"
    },
    "warnings": {
        "0": "Phone number missing country code",
        "1": "State code missing",
        "2": "Zip code missing"
    }
}'

## JSONpointer
j_flatten(json) |>
    cat("\n")

## JSONpath
j_flatten(json, as = "R", path_type = "JSONpath") |>
    str()

j_find_values(json, "Zip code missing", as = "tibble")
j_find_values(
    json,
    c("Queue limit exceeded", "Zip code missing"),
    as = "tibble"
)

j_find_values_grep(json, "missing", as = "tibble")

## JSONpath
j_find_values_grep(json, "missing", as = "tibble", path_type = "JSONpath")

j_find_keys(json, "discards", as = "tibble")
j_find_keys(json, "1", as = "tibble")
j_find_keys(json, c("discards", "warnings"), as = "tibble")

## JSONpath
j_find_keys(json, "discards", as = "tibble", path_type = "JSONpath")

j_find_keys_grep(json, "discard", as = "tibble")
j_find_keys_grep(json, "1", as = "tibble")
j_find_keys_grep(json, "car.*/101", as = "tibble")

## JSONpath
j_find_keys_grep(json, "car.*\\\\['101", as = "tibble", path_type = "JSONpath")

## NDJSON

ndjson_file <-
    system.file(package = "rjsoncons", "extdata", "example.ndjson")
j_flatten(ndjson_file) |>
    noquote()
j_find_values_grep(ndjson_file, "e") |>
    str()
}
