% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetMatrix.R
\name{fastMobius}
\alias{fastMobius}
\alias{invMobius}
\title{Fast Moebius and inverse Moebius transforms}
\usage{
fastMobius(x, pad = FALSE)

invMobius(x, pad = FALSE)
}
\arguments{
\item{x}{vector to transform}

\item{pad}{logical, should vector not of length 2^k be padded with zeroes?}
}
\description{
Uses the fast method of Kennes and Smets (1990) to obtain Moebius and 
inverse Moebius transforms.
}
\details{
These are respectively equivalent to multiplying \code{abs(subsetMatrix(k))} 
and \code{subsetMatrix(k)} by \code{x}, when \code{x} has length \eqn{2^k}, but is 
much faster if \eqn{k} is large.
}
\section{Functions}{
\itemize{
\item \code{invMobius}: inverse transform
}}

\examples{
x <- c(1,0,-1,2,4,3,2,1)
M <- subsetMatrix(3)
M \%*\% abs(M) \%*\% x
invMobius(fastMobius(x))

}
