% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jade.R
\name{jade_compile}
\alias{jade_compile}
\alias{jade}
\alias{jade_render}
\title{Render Jade Template}
\usage{
jade_compile(text, ...)

jade_render(text, ..., locals = list())
}
\arguments{
\item{text}{string with jade template.}

\item{...}{options passed to the compiler, see \url{https://jade-lang.com/api}.}

\item{locals}{local variables used in the template.}
}
\description{
Jade is a high performance template engine heavily influenced by Haml.
}
\details{
Converting a template to HTML text involves two steps. The first step compiles
the template with some formatting options into a closure. The binding for this
is implemented in \code{jade_compile}. The second step calls the closure with
optionally some local variables to render the output to HTML.

The \code{jade_render} function is a convenience wrapper that does both steps at
once. This is slightly faster if you only need to render your template once.
}
\examples{
# Example from https://jade-lang.com
text <- readLines(system.file("examples/test.jade", package = "rjade"))

# Compile and render seperately
tpl <- jade_compile(text, pretty = TRUE)
tpl()
tpl(youAreUsingJade = TRUE)

# Slightly faster for one-time rendering
jade_render(text, pretty = TRUE)
jade_render(text, pretty = TRUE, locals = list(youAreUsingJade = TRUE))
}
\references{
Jade documentation: \url{https://jade-lang.com}
}
