% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_make.R
\name{rxp_make}
\alias{rxp_make}
\title{Build pipeline using Nix}
\usage{
rxp_make(verbose = 0L, max_jobs = 1, cores = 1)
}
\arguments{
\item{verbose}{Integer, defaults to 0L. Verbosity level: 0 = show progress
indicators only, 1+ = show nix output with increasing verbosity. 0:
"Progress only", 1: "Informational", 2: "Talkative", 3: "Chatty", 4: "Debug",
5: "Vomit". Values higher than 5 are capped to 5.
Each level adds one --verbose flag to nix-store command.}

\item{max_jobs}{Integer, number of derivations to be built in parallel.}

\item{cores}{Integer, number of cores a derivation can use during build.}
}
\value{
A character vector of paths to the built outputs.
}
\description{
Runs \code{nix-build} with a quiet flag, outputting to \verb{_rixpress/result}.
}
\examples{
\dontrun{
  # Build the pipeline with progress indicators (default)
  rxp_make()

  # Build with verbose output and parallel execution
  rxp_make(verbose = 2, max_jobs = 4, cores = 2)

  # Maximum verbosity
  rxp_make(verbose = 3)
}
}
\seealso{
Other pipeline functions: 
\code{\link{rxp_populate}()}
}
\concept{pipeline functions}
