% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_graph_directionality.R
\name{set_graph_directionality}
\alias{set_graph_directionality}
\title{Create directed river graph based on outlet flag}
\usage{
set_graph_directionality(graph, field_name = "name", outlet_name)
}
\arguments{
\item{graph}{an 'igraph' object representing a river structure where reaches are nodes and confluences (or fragmentation items) are links.}

\item{field_name}{a character value that flags the vertices attribute used to designate the outlet.
Each vertex must have an unique value for this field.}

\item{outlet_name}{a character value corresponding to the 'field_name' attribute}
}
\value{
an object of class 'igraph' containing a directed graph.
}
\description{
The input graph can be either directed or undirected. If directed, then it is made undirected before directionality is assigned.
}
\examples{
library(igraph)
g <- igraph::graph_from_literal(1-2, 2-4, 3-2, 4-6, 6-7, 5-6, 7-8, 9-5, 10-5 )
g1 <- set_graph_directionality(g, field_name = "name", "8")

}
