% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_risk}
\alias{get_risk}
\title{Calculate Risk Probability from Score}
\usage{
get_risk(object, score)
}
\arguments{
\item{object}{An object of class "risk_mod", usually a result of a call to
\code{\link[=risk_mod]{risk_mod()}}.}

\item{score}{Numeric vector with score value(s).}
}
\value{
Numeric vector with the same length as \code{score}.
}
\description{
Returns the risk probabilities for the provided score value(s).
}
\examples{
y <- breastcancer[[1]]
X <- as.matrix(breastcancer[,2:ncol(breastcancer)])

mod <- risk_mod(X, y)
get_risk(mod, score = c(1, 10, 20))

}
