% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{imkdir}
\alias{imkdir}
\title{Create a New Collection in iRODS}
\usage{
imkdir(
  logical_path,
  create_parent_collections = FALSE,
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{logical_path}{Path to the collection to create, relative to the current
working directory (see \code{\link[=ipwd]{ipwd()}}).}

\item{create_parent_collections}{Whether parent collections should be created
when necessary. Defaults to \code{FALSE}.}

\item{overwrite}{Whether the existing collection should be overwritten
if it exists. Defaults to \code{FALSE}.}

\item{verbose}{Whether information about the HTTP request and response
should be printed. Defaults to \code{FALSE}.}
}
\value{
Invisibly the HTTP request.
}
\description{
This is the equivalent to \code{\link[=dir.create]{dir.create()}}, but creating a collection in iRODS
instead of a local directory.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authentication
iauth("rods", "rods")

# list all object and collection in the current collection of iRODS
ils()

# create a new collection
imkdir("new_collection")

# check if it is there
ils()

# and move to the new directory
icd("new_collection")

# remove collection
icd("..")
irm("new_collection", force = TRUE, recursive = TRUE)
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=irm]{irm()}} for removing collections,
\code{\link[=dir.create]{dir.create()}} for an R equivalent.
}
