% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{CSample}
\alias{CSample}
\title{CSample Class}
\description{
This class represents a sample of connectomes, with various properties and methods to handle their tangent and vectorized images.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{connectomes}}{Connectomes data}

\item{\code{tangent_images}}{Tangent images data}

\item{\code{vector_images}}{Vector images data}

\item{\code{sample_size}}{Sample size}

\item{\code{matrix_size}}{Matrix size}

\item{\code{mfd_dim}}{Manifold dimension}

\item{\code{is_centered}}{Centering status}

\item{\code{frechet_mean}}{Frechet mean}

\item{\code{riem_metric}}{Riemannian Metric used}

\item{\code{variation}}{Variation of the sample}

\item{\code{sample_cov}}{Sample covariance}

\item{\code{ref_point}}{Reference point for tangent or vectorized images}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CSample-new}{\code{CSample$new()}}
\item \href{#method-CSample-compute_tangents}{\code{CSample$compute_tangents()}}
\item \href{#method-CSample-compute_conns}{\code{CSample$compute_conns()}}
\item \href{#method-CSample-compute_vecs}{\code{CSample$compute_vecs()}}
\item \href{#method-CSample-compute_unvecs}{\code{CSample$compute_unvecs()}}
\item \href{#method-CSample-compute_fmean}{\code{CSample$compute_fmean()}}
\item \href{#method-CSample-change_ref_pt}{\code{CSample$change_ref_pt()}}
\item \href{#method-CSample-center}{\code{CSample$center()}}
\item \href{#method-CSample-compute_variation}{\code{CSample$compute_variation()}}
\item \href{#method-CSample-compute_sample_cov}{\code{CSample$compute_sample_cov()}}
\item \href{#method-CSample-clone}{\code{CSample$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-new"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-new}{}}}
\subsection{Method \code{new()}}{
Initialize a CSample object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$new(
  conns = NULL,
  tan_imgs = NULL,
  vec_imgs = NULL,
  centered = NULL,
  ref_pt = NULL,
  metric_obj
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conns}}{A list of connectomes (default is NULL).}

\item{\code{tan_imgs}}{A list of tangent images (default is NULL).}

\item{\code{vec_imgs}}{A matrix whose rows are vectorized images (default is NULL).}

\item{\code{centered}}{Boolean indicating whether tangent or vectorized images are centered (default is NULL).}

\item{\code{ref_pt}}{A connectome (default is identity)}

\item{\code{metric_obj}}{Object of class \code{rmetric} representing the Riemannian metric used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CSample} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_tangents"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_tangents}{}}}
\subsection{Method \code{compute_tangents()}}{
This function computes the tangent images from the connectomes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_tangents(ref_pt = default_ref_pt(private$p))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ref_pt}}{A reference point, which must be a \code{dppMatrix} object (default is \code{default_ref_pt}).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Error if \code{ref_pt} is not a \code{dppMatrix} object or if \code{conns} is not specified.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_conns"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_conns}{}}}
\subsection{Method \code{compute_conns()}}{
This function computes the connectomes from the tangent images.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_conns()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Error if tangent images are not specified.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_vecs"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_vecs}{}}}
\subsection{Method \code{compute_vecs()}}{
This function computes the vectorized tangent images from the tangent images.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_vecs()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Error if tangent images are not specified.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_unvecs"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_unvecs}{}}}
\subsection{Method \code{compute_unvecs()}}{
This function computes the tangent images from the vector images.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_unvecs()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Error if \code{vec_imgs} is not specified.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_fmean"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_fmean}{}}}
\subsection{Method \code{compute_fmean()}}{
This function computes the Frechet mean of the sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_fmean(tol = 0.05, max_iter = 20, lr = 0.2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tol}}{Tolerance for the convergence of the mean (default is 0.05).}

\item{\code{max_iter}}{Maximum number of iterations for the computation (default is 20).}

\item{\code{lr}}{Learning rate for the optimization algorithm (default is 0.2).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-change_ref_pt"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-change_ref_pt}{}}}
\subsection{Method \code{change_ref_pt()}}{
This function changes the reference point for the tangent images.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$change_ref_pt(new_ref_pt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_ref_pt}}{A new reference point, which must be a \code{dppMatrix} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Error if tangent images have not been computed or if \code{new_ref_pt} is not a \code{dppMatrix} object.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-center"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-center}{}}}
\subsection{Method \code{center()}}{
Center the sample
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$center()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function centers the sample by computing the Frechet mean if it is not already computed, and then changing the reference point to the computed Frechet mean. Error if tangent images are not specified. Error if the sample is already centered.
}

\subsection{Returns}{
None. This function is called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_variation"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_variation}{}}}
\subsection{Method \code{compute_variation()}}{
Compute Variation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_variation()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function computes the variation of the sample. It first checks if the vector images are null, and if so, it computes the vectors, computing first the tangent images if necessary. If the sample is not centered, it centers the sample and recomputes the vectors. Finally, it calculates the variation as the mean of the sum of squares of the vector images. Error if \code{vec_imgs} is not specified.
}

\subsection{Returns}{
None. This function is called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-compute_sample_cov"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-compute_sample_cov}{}}}
\subsection{Method \code{compute_sample_cov()}}{
Compute Sample Covariance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$compute_sample_cov()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function computes the sample covariance matrix for the vector images. It first checks if the vector images are null, and if so, it computes the vectors, computing first the tangent images if necessary.
}

\subsection{Returns}{
None. This function is called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSample-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CSample-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
