% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmeta.R, R/options.R
\name{gmeta}
\alias{gmeta}
\alias{getLocationProj}
\alias{gmeta2grd}
\alias{print.gmeta}
\alias{get.ignore.stderrOption}
\alias{get.stop_on_no_flags_parasOption}
\alias{get.echoCmdOption}
\alias{get.useInternOption}
\alias{get.legacyExecOption}
\alias{get.defaultFlagsOption}
\alias{get.suppressEchoCmdInFuncOption}
\alias{set.ignore.stderrOption}
\alias{set.stop_on_no_flags_parasOption}
\alias{set.echoCmdOption}
\alias{set.useInternOption}
\alias{set.legacyExecOption}
\alias{set.defaultFlagsOption}
\alias{set.suppressEchoCmdInFuncOption}
\title{Reads GRASS metadata from the current LOCATION}
\usage{
gmeta(ignore.stderr = FALSE, g.proj_WKT = NULL)

getLocationProj(ignore.stderr = FALSE, g.proj_WKT = NULL)

gmeta2grd(ignore.stderr = FALSE)

\method{print}{gmeta}(x, ...)

get.ignore.stderrOption()

get.stop_on_no_flags_parasOption()

get.echoCmdOption()

get.useInternOption()

get.legacyExecOption()

get.defaultFlagsOption()

get.suppressEchoCmdInFuncOption()

set.ignore.stderrOption(value)

set.stop_on_no_flags_parasOption(value)

set.echoCmdOption(value)

set.useInternOption(value)

set.legacyExecOption(value)

set.defaultFlagsOption(value)

set.suppressEchoCmdInFuncOption(value)
}
\arguments{
\item{ignore.stderr}{default FALSE, can be set to TRUE to silence
\code{system()} output to standard error; does not apply on Windows
platforms.}

\item{g.proj_WKT}{default NULL: return WKT2 representation in GRASS >= 7.6
and Proj4 in GRASS < 7.6; may be set to FALSE to return Proj4 for GRASS >=
7.6.}

\item{x}{S3 object returned by gmeta}

\item{...}{arguments passed through print method}

\item{value}{logical value for setting options on \code{ignore.stderr} set by
default on package load to FALSE, \code{stop_on_no_flags_params} set by default
on package load to TRUE, \code{echoCmd} set by default on package load to FALSE.
\code{useIntern} sets the intern argument globally; \code{legacyExec} sets the
legacyExec option globally, but is initialized to FALSE on unix systems
(all but Windows) and TRUE on Windows; \code{defaultFlags} is initialized to
NULL, but may be a character vector with values from c("quiet", "verbose")
\code{suppressEchoCmdInFunc} default TRUE suppresses the effect of echoCmd
within package functions, maybe set FALSE for debugging.}
}
\value{
Returns list of g.gisenv, g.region -g3, and g.proj values.
}
\description{
GRASS LOCATION metadata are read into a list in R; helper function
getLocationProj returns a WKT2 string of projection information. The helper
function \code{gmeta2grd} creates a GridTopology object from the current
GRASS mapset region definitions.
}
\examples{
run <- FALSE
if (nchar(Sys.getenv("GISRC")) > 0 &&
    read.dcf(Sys.getenv("GISRC"))[1, "LOCATION_NAME"] == "nc_basic_spm_grass7") {
  run <- TRUE
}

if (run) {
  G <- gmeta()
  print(G)
}

if (run) {
  cat(getLocationProj(), "\n")
  cat(getLocationProj(g.proj_WKT = FALSE), "\n")
}

if (run) {
  grd <- gmeta2grd()
  print(grd)
}

if (run) {
  ncells <- prod(slot(grd, "cells.dim"))
  df <- data.frame(k = rep(1, ncells))
  mask_SG <- sp::SpatialGridDataFrame(grd, data = df)
  print(summary(mask_SG))
}
}
\author{
Roger S. Bivand, e-mail: \href{mailto:Roger.Bivand@nhh.no}{Roger.Bivand@nhh.no}
}
\keyword{spatial}
