% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml1.R
\name{execGRASS}
\alias{execGRASS}
\alias{stringexecGRASS}
\alias{doGRASS}
\alias{parseGRASS}
\alias{print.GRASS_interface_desc}
\alias{getXMLencoding}
\alias{setXMLencoding}
\title{Run GRASS commands}
\usage{
execGRASS(
  cmd,
  flags = NULL,
  ...,
  parameters = NULL,
  intern = NULL,
  ignore.stderr = NULL,
  Sys_ignore.stdout = FALSE,
  Sys_wait = TRUE,
  Sys_input = NULL,
  Sys_show.output.on.console = TRUE,
  Sys_minimized = FALSE,
  Sys_invisible = TRUE,
  echoCmd = NULL,
  redirect = FALSE,
  legacyExec = NULL
)

stringexecGRASS(
  string,
  intern = NULL,
  ignore.stderr = NULL,
  Sys_ignore.stdout = FALSE,
  Sys_wait = TRUE,
  Sys_input = NULL,
  Sys_show.output.on.console = TRUE,
  Sys_minimized = FALSE,
  Sys_invisible = TRUE,
  echoCmd = NULL,
  redirect = FALSE,
  legacyExec = NULL
)

doGRASS(
  cmd,
  flags = NULL,
  ...,
  parameters = NULL,
  echoCmd = NULL,
  legacyExec = NULL
)

parseGRASS(cmd, legacyExec = NULL)

\method{print}{GRASS_interface_desc}(x, ...)

getXMLencoding()

setXMLencoding(enc)
}
\arguments{
\item{cmd}{GRASS command name.}

\item{flags}{character vector of GRASS command flags.}

\item{...}{for \code{execGRASS} and \code{doGRASS}, GRASS module parameters
given as R named arguments directly. For the \code{print} method, other
arguments to print method. The storage modes of values passed must match
those required in GRASS, so a single GRASS string must be a character vector
of length 1, a single GRASS integer must be an integer vector of length 1
(may be an integer constant such as 10L), and a single GRASS float must be
a numeric vector of length 1. For multiple values, use vectors of suitable
length.}

\item{parameters}{list of GRASS command parameters, used if GRASS parameters
are not given as R arguments directly; the two methods for passing GRASS
parameters may not be mixed. The storage modes of values passed must match
those required in GRASS, so a single GRASS string must be a character vector
of length 1, a single GRASS integer must be an integer vector of length 1
(may be an integer constant such as 10L), and a single GRASS float must be
a numeric vector of length 1. For multiple values, use vectors of suitable
length.}

\item{intern}{default NULL, in which case set internally from
\code{get.useInternOption}; a logical (not 'NA') which indicates whether to
make the output of the command an R object. Not available unless 'popen' is
supported on the platform.}

\item{ignore.stderr}{default NULL, taking the value set by
\code{set.ignore.stderrOption}, a logical indicating whether error messages
written to 'stderr' should be ignored.}

\item{Sys_ignore.stdout, Sys_wait, Sys_input}{pass extra arguments to
\code{system}.}

\item{Sys_show.output.on.console, Sys_minimized, Sys_invisible}{pass extra
arguments to \code{system} on Windows systems only.}

\item{echoCmd}{default NULL, taking the logical value set by
\code{set.echoCmdOption}, print GRASS command to be executed to console.}

\item{redirect}{default \code{FALSE}, if \code{TRUE}, add "2>&1" to
the command string and set \code{intern} to \code{TRUE}; only used in
legacy mode.}

\item{legacyExec}{default NULL, taking the logical value set by
\code{set.legacyExecOption} which is initialised to \code{FALSE} on
"unix" platforms and \code{TRUE} otherwise. If \code{TRUE}, use
\code{system}, if \code{FALSE} use \code{system2} and divert stderr to
temporary file to record error messages and warnings from GRASS modules.}

\item{string}{a string representing \emph{one} full GRASS statement, using shell
syntax: command name, optionally followed by flags and parameters, all
separated by whitespaces. Parameters follow the key=value format; if
’value’ contains spaces, then ’value’ must be quoted}

\item{x}{object to be printed}

\item{enc}{character string to replace UTF-8 in header of XML data generated
by GRASS module –interface-description output when the internationalised
messages are not in UTF-8 (known to apply to French, which is in latin1)}
}
\value{
\code{parseGRASS} returns a \code{GRASS_interface_desc} object,
\code{doGRASS} returns a character string with a proposed GRASS command -
the expanded command name is returned as an attribute, and \code{execGRASS}
and  \code{stringexecGRASS} return what \code{system} or \code{system2}
return, particularly depending on the \code{intern} argument when the
character strings output by GRASS modules are returned.

If \code{intern} is \code{FALSE}, \code{system} returns the module exit
code, while \code{system2} returns the module exit code with
"resOut" and "resErr" attributes.
}
\description{
The functions provide an interface to GRASS commands run through
\code{system}, based on the values returned by the \verb{--interface description}
flag using XML parsing. If required parameters are omitted, and
have declared defaults, the defaults will be used.
}
\details{
\code{parseGRASS} checks to see whether the GRASS command has been parsed
already and cached in this session; if not, it reads the interface
description, parses it and caches it for future use. \code{doGRASS} assembles
a proposed GRASS command with flags and parameters as a string, wrapping
\code{parseGRASS}, and \code{execGRASS} is a wrapper for \code{doGRASS},
running the command through \code{system} (from 0.7-4, the \code{...}
argument is not used for passing extra arguments for \code{system}). The
command string is termed proposed, because not all of the particular needs of
commands are provided by the interface description, and no check is made for
the existence of input objects. Support for multiple parameter values added
with help from Patrick Caldon. Support for defaults and for direct use of
GRASS parameters instead of a parameter list suggested by Rainer Krug.

\code{stringexecGRASS} is a wrapper around \code{execGRASS}, and accepts a
single shell statement as a string (following GRASS's command syntax).
}
\note{
If any package command fails with a UTF-8 error from the XML package, try
using \code{setXMLencoding} to work around the problem that GRASS modules
declare --interface-description output as UTF-8 without ensuring that it is
(French is of 6.4.0 RC5 latin1).
}
\examples{
# Run examples if in an active GRASS session in the nc_basic_spm_grass7
Sys.setenv("_SP_EVOLUTION_STATUS_" = "2")
run <- FALSE
GISRC <- Sys.getenv("GISRC")
if (nchar(GISRC) > 0) {
  location_name <- read.dcf(GISRC)[1, "LOCATION_NAME"]
  if (location_name == "nc_basic_spm_grass7") {
    run <- TRUE
  }
}

# Save and set echo command option
echoCmdOption <- get.echoCmdOption()
set.echoCmdOption(TRUE)

if (run) {
  # Read and print GRASS interface description for 'r.slope.aspect'
  print(parseGRASS("r.slope.aspect"))
}
if (run) {
  # Assemble the 'r.slope.aspect' command with specified parameters as a string
  doGRASS(
    "r.slope.aspect",
    flags = c("overwrite"),
    elevation = "elevation.dem",
    slope = "slope",
    aspect = "aspect"
  )
}
if (run) {
  # Alternatively, specify parameters as a list
  params <- list(elevation = "elevation",
                 slope = "slope",
                 aspect = "aspect")
  doGRASS("r.slope.aspect",
          flags = c("overwrite"),
          parameters = params)
}
if (run) {
  # Read and print GRASS interface description for 'r.buffer'
  print(parseGRASS("r.buffer"))
}
if (run) {
  # Assemble the 'r.buffer' with specified parameters as as string
  doGRASS(
    "r.buffer",
    flags = c("overwrite"),
    input = "schools",
    output = "bmap",
    distances = seq(1000, 15000, 1000)
  )
}
if (run) {
  # Alternatively, specify parameters as a list
  params <- list(
    input = "schools",
    output = "bmap",
    distances = seq(1000, 15000, 1000)
  )
  doGRASS("r.buffer", flags = c("overwrite"), parameters = params)
}
if (run) {
  # Restore original echo command option
  set.echoCmdOption(echoCmdOption)

  # Try executing 'r.stats' command which will fail because "fire_blocksgg"
  # does not exist in the mapset
  try(res <- execGRASS("r.stats", input = "fire_blocksgg", flags = c("C", "n")),
      silent = FALSE)
}
if (run) {
  # Execute 'r.stats' with legacyExec and print the result
  res <- execGRASS(
    "r.stats",
    input = "fire_blocksgg",
    flags = c("C", "n"),
    legacyExec = TRUE
  )
  print(res)
}
if (run) {
  # If the command failed, retrieve error message
  if (res != 0) {
    resERR <- execGRASS(
      "r.stats",
      input = "fire_blocksgg",
      flags = c("C", "n"),
      redirect = TRUE,
      legacyExec = TRUE
    )
    print(resERR)
  }
}
if (run) {

  # Use 'stringexecGRASS' to run a command and print the result
  res <- stringexecGRASS("r.stats -p -l input=geology", intern = TRUE)
  print(res)

  stringexecGRASS(
    "r.random.cells --overwrite --quiet output=samples distance=1000 ncells=100 seed=1"
  )
}
if (run) {
  # Alternatively, run the same command using 'execGRASS'
  execGRASS(
    "r.random.cells",
    flags  = c("overwrite", "quiet"),
    output = "samples",
    distance = 1000,
    ncells = 100L,
    seed = 1L
  )
}
}
\seealso{
\code{\link[base:system]{base::system()}}
}
\author{
Roger S. Bivand, e-mail: \href{mailto:Roger.Bivand@nhh.no}{Roger.Bivand@nhh.no}
}
\keyword{spatial}
