% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_sparse6.R
\name{from_sparse6}
\alias{from_sparse6}
\alias{edgelist_from_sparse6}
\alias{igraph_from_sparse6}
\alias{network_from_sparse6}
\title{Parsing 'sparse6' symbols}
\usage{
edgelist_from_sparse6(s6)

igraph_from_sparse6(s6)

network_from_sparse6(s6)
}
\arguments{
\item{s6}{character vector of 'sparse6' symbols}
}
\value{
The returned object is:

\itemize{
\item for \code{\link[=edgelist_from_sparse6]{edgelist_from_sparse6()}}, a list of the same length as its
input of two-column edgelist matrices. The matrix has a \code{gorder} attribute
storing the number of vertices in the graph.
}

\itemize{
\item for \code{\link[=igraph_from_sparse6]{igraph_from_sparse6()}}, a list of 'igraph' objects
}

\itemize{
\item for \code{\link[=network_from_sparse6]{network_from_sparse6()}}, a list of 'network' objects
}
}
\description{
These functions take a character vector of 'sparse6' symbols and
return a list of other types of objects:

\itemize{
\item \code{\link[=edgelist_from_sparse6]{edgelist_from_sparse6()}} creates edgelist matrices
}

\itemize{
\item \code{\link[=igraph_from_sparse6]{igraph_from_sparse6()}} creates 'igraph' objects. Requires
package \pkg{igraph} to be installed.
}

\itemize{
\item \code{\link[=network_from_sparse6]{network_from_sparse6()}} creates 'network' objects. Requires
package \pkg{network} to be installed.
}
}
\examples{
elm <- structure(c(1, 1, 2, 2, 4, 4, 5, 6, 9, 10, 7, 8, 4, 8, 6, 8,  
  8, 5, 4, 6), .Dim = c(10L, 2L))
s6 <- as_sparse6(elm, n = 10)

# To edgelist matrix -------------------------------------------------------
edgelist_from_sparse6(s6)

# To igraph object ---------------------------------------------------------
if(requireNamespace("igraph", quietly=TRUE)) {
  igraph_from_sparse6(s6)
}

# To network object --------------------------------------------------------
if(requireNamespace("network", quietly=TRUE)) {
  network_from_sparse6(s6)
}

}
\seealso{
\code{\link[=as_sparse6]{as_sparse6()}} for encoding network data objects as 'sparse6'
symbols.
}
