% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_interactions_by_type}
\alias{get_interactions_by_type}
\title{Get Species Interactions by Interaction Type from GloBI}
\usage{
get_interactions_by_type(interactiontype = c("interactsWith"), ...)
}
\arguments{
\item{interactiontype}{the requested interaction type (e.g. preysOn)}

\item{...}{list of options to configure GloBI API}
}
\value{
species interactions given provided interaction type(s)
}
\description{
Get Species Interactions by Interaction Type from GloBI
}
\examples{
\donttest{
get_interactions_by_type(interactiontype = c("eats", "eatenBy"))
get_interactions_by_type(interactiontype = "parasiteOf")
}
}
\seealso{
Other interactions: 
\code{\link{get_interaction_matrix}()},
\code{\link{get_interaction_types}()},
\code{\link{get_interactions_by_taxa}()},
\code{\link{get_interactions}()},
\code{\link{get_predators_of}()},
\code{\link{get_prey_of}()}
}
\concept{interactions}
