% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cry_demo.R
\name{cry_demo}
\alias{cry_demo}
\title{Examples of using the cry and rgl packages together.}
\usage{
cry_demo(file = NULL, rf = 1, type = "b", zoom = 1)
}
\arguments{
\item{file}{Optional file in CIF formats. The file can also be specified by
URL.}

\item{rf}{A positive value indicating the scale factor of atom radius.}

\item{type}{A style of atom displaying such like ball, fill and ball-stick
but ball-stick is not implemented.}

\item{zoom}{A positive value indicating the current scene magnification.}
}
\value{
An integer the device number of the currently window.
}
\description{
Read a file in CIF formats, set the parameters, calculates them, and draws
the crystal structure with an axis widget.
}
\details{
If no file argument is provided, and \code{dp_demo()} has been opened without
paired \code{cry_demo()}, the CIF parameters of already opened \code{dp_demo()} will be
used.
}
\examples{
cry_demo()
cry_demo(system.file("orthorhombic_p.cif", package = "rgl.cry"))

\donttest{
if (interactive()) {
 cry_demo(file, type = "fill", zoom = 0.5)
 cry_demo("https://www.crystallography.net/cod/foo.cif")
}
}
}
