% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spd-matrices.R
\name{SPDMatrix}
\alias{SPDMatrix}
\title{Class for the Manifold of Symmetric Positive Definite Matrices}
\usage{
SPDMatrix(n, ...)
}
\arguments{
\item{n}{An integer value specifying the number of rows and columns of the
matrices.}

\item{...}{Extra arguments to be passed to parent class constructors. See
\code{\link{OpenSet}} and \code{\link{Manifold}} classes.}
}
\value{
An object of class \code{\link{SPDMatrices}}.
}
\description{
This function generates an instance of the class for the manifold of
symmetric positive definite matrices \eqn{\mathrm{SPD}(n)}.
}
\examples{
if (reticulate::py_module_available("geomstats")) {
  spd3 <- SPDMatrix(n = 3)
  spd3
}
}
\seealso{
Other symmetric positive definite matrix classes: 
\code{\link{SPDMatrices}}
}
\author{
Yann Thanwerdas
}
\concept{symmetric positive definite matrix classes}
