% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lie-algebra.R
\name{MatrixLieAlgebra}
\alias{MatrixLieAlgebra}
\title{Abstract Class for Matrix Lie Algebras}
\description{
There are two main forms of representation for elements of a
matrix Lie algebra implemented here. The first one is as a matrix, as
elements of \eqn{R^{n \times n}}. The second is by choosing a basis and
remembering the coefficients of an element in that basis. This basis will
be provided in child classes (e.g. \code{SkewSymmetricMatrices}).
}
\author{
Stefan Heyder
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:VectorSpace]{rgeomstats::VectorSpace}} -> \code{MatrixLieAlgebra}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n}}{An integer value representing the number of rows and columns in
the matrix representation of the Lie algebra.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MatrixLieAlgebra-new}{\code{MatrixLieAlgebra$new()}}
\item \href{#method-MatrixLieAlgebra-baker_campbell_hausdorff}{\code{MatrixLieAlgebra$baker_campbell_hausdorff()}}
\item \href{#method-MatrixLieAlgebra-basis_representation}{\code{MatrixLieAlgebra$basis_representation()}}
\item \href{#method-MatrixLieAlgebra-matrix_representation}{\code{MatrixLieAlgebra$matrix_representation()}}
\item \href{#method-MatrixLieAlgebra-clone}{\code{MatrixLieAlgebra$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="VectorSpace" data-id="projection"><a href='../../rgeomstats/html/VectorSpace.html#method-VectorSpace-projection'><code>rgeomstats::VectorSpace$projection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieAlgebra-new"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieAlgebra-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{MatrixLieAlgebra}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieAlgebra$new(dim, n, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the Lie algebra
as a real vector space.}

\item{\code{n}}{An integer value representing the number of rows and columns in
the matrix representation of the Lie algebra.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{VectorSpace}} and  \code{\link{Manifold}} classes.}

\item{\code{py_cls}}{A Python object of class \code{MatrixLieAlgebra}. Defaults to
\code{NULL} in which case it is instantiated on the fly using the other
input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{MatrixLieAlgebra}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieAlgebra-baker_campbell_hausdorff"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieAlgebra-baker_campbell_hausdorff}{}}}
\subsection{Method \code{baker_campbell_hausdorff()}}{
Calculates the Baker-Campbell-Hausdorff approximation of
given order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieAlgebra$baker_campbell_hausdorff(matrix_a, matrix_b, order = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{matrix_a}}{A numeric array of shape \eqn{... \times n \times n}
specifying a matrix or a sample of matrices.}

\item{\code{matrix_b}}{A numeric array of shape \eqn{... \times n \times n}
specifying a matrix or a sample of matrices.}

\item{\code{order}}{An integer value specifying the order to which the
approximation is calculated. Note that this is NOT the same as using
only \eqn{e_i} with \eqn{i < \mathrm{order}}. Defaults to \code{2L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The implementation is based on
\insertCite{casas2009efficient;textual}{rgeomstats} with the
pre-computed constants taken from
\insertCite{casas2009data;textual}{rgeomstats}. Our coefficients are
truncated to enable us to calculate BCH up to order \eqn{15}. This
represents \deqn{Z = \log \left( \exp(X) \exp(Y) \right)} as an
infinite linear combination of the form \deqn{Z = \sum_i z_i e_i} where
\eqn{z_i} are rational numbers and \eqn{e_i} are iterated Lie brackets
starting with \eqn{e_1 = X}, \eqn{e_2 = Y}, each \eqn{e_i} is given by
some \eqn{(i^\prime,i^{\prime\prime})} such that \eqn{e_i =
  [e_i^\prime, e_i^{\prime\prime}]}.
}

\subsection{Returns}{
A numeric array of shape \eqn{... \times n \times n} storing a
matrix or a sample of matrices corresponding to the BCH
approximation(s) between input matrices.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieAlgebra-basis_representation"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieAlgebra-basis_representation}{}}}
\subsection{Method \code{basis_representation()}}{
Computes the coefficients of matrices in the given basis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieAlgebra$basis_representation(matrix_representation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{matrix_representation}}{A numeric array of shape \eqn{... \times n
  \times n} specifying a matrix or a sample of matrices in its matrix
representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{... \times \mathrm{dim}} storing a
matrix or a sample of matrices in its basis representation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieAlgebra-matrix_representation"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieAlgebra-matrix_representation}{}}}
\subsection{Method \code{matrix_representation()}}{
Compute the matrix representation for the given basis
coefficients.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieAlgebra$matrix_representation(basis_representation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{basis_representation}}{A numeric array of shape \eqn{... \times
  \mathrm{dim}} storing a matrix or a sample of matrices in its basis
representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sums the basis elements according to the coefficients given in
basis representation.
}

\subsection{Returns}{
A numeric array of shape \eqn{... \times n \times n} specifying a
matrix or a sample of matrices in its matrix representation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieAlgebra-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieAlgebra-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieAlgebra$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
