% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcorplot.R
\name{f_corplot}
\alias{f_corplot}
\title{Correlation Plots with Factor Detection and Customization}
\usage{
f_corplot(
  data,
  detect_factors = TRUE,
  factor_table = FALSE,
  color_factor = "auto",
  shape_factor = "auto",
  print_legend = TRUE,
  fancy_names = NULL,
  width = 15,
  height = 15,
  res = 600,
  pointsize = 8,
  legendname = NULL,
  close_generated_files = FALSE,
  open_generated_files = TRUE,
  output_type = "word",
  output_file = NULL,
  output_dir = NULL,
  save_in_wdir = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} containing the dataset to be visualized. Must include at least two numeric variables.}

\item{detect_factors}{Logical. If \code{TRUE}, the function automatically detects factor variables in the dataset for coloring and shaping points. Defaults to \code{TRUE}.}

\item{factor_table}{Logical. If \code{TRUE}, prints a detailed table about the properties of the converted factors to the console. Default is FALSE, so no property table will be printed to the console.}

\item{color_factor}{Character. The name of the factor variable to use for point colors. If set to \code{"auto"}, it is automatically determined based on detected factors. Defaults to \code{"auto"}.}

\item{shape_factor}{Character. The name of the factor variable to use for point shapes. If set to \code{"auto"}, it is automatically determined based on detected factors. Defaults to \code{"auto"}.}

\item{print_legend}{Logical. If \code{TRUE}, a separate legend file is created and displayed. Defaults to \code{TRUE}.}

\item{fancy_names}{Named character vector or \code{NULL}. Optional mapping of column names to more readable names for display in plots and legends.}

\item{width}{Numeric. The width of the output plot in centimeters (default 15 cm).}

\item{height}{Numeric. The height of the output plot in centimeters (default 15 cm).}

\item{res}{Numeric. The resolution (in dots per inch) for the output plot image (defaults 1000 dpi).}

\item{pointsize}{Numeric. The base font size for text in the plot image. Defaults to 8.}

\item{legendname}{Character string or \code{NULL}. The name of the file (omit extension) where the legend will be saved. If \code{NULL}, a default filename is generated based on the dataset name (dataname_legend_correlation_plot). Defaults to \code{NULL}.}

\item{close_generated_files}{Logical. If \code{TRUE}, closes open 'Word' files depending on the output format. This to be able to save the newly generated files. 'Pdf' files should also be closed before using the function and cannot be automatically closed. Default is \code{FALSE}.}

\item{open_generated_files}{Logical. If \code{TRUE}, Opens the generated 'Word' output files. This to directly view the results after creation. Files are stored in tempdir(). Default is \code{TRUE}.}

\item{output_type}{Character string specifying the output format: "pdf", "word", "png" or "rmd". Default is "word".}

\item{output_file}{Character string or \code{NULL}. The name of the file (omit extension) where the cor_plot will be saved. If \code{NULL}, a default filename is generated based on the dataset name (dataname_correlation_plot). Defaults to \code{NULL}.}

\item{output_dir}{Character string specifying the name of the directory of the output file. Default is  \code{tempdir()}. If the \code{output_file} already contains a directory name \code{output_dir} can be omitted, if used it overwrites the dir specified in \code{output_file}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory Default is \code{FALSE}, to avoid unintended changes to the global environment. If the \code{output_dir} is specified \code{save_in_wdir} is overwritten with \code{output_dir}.}
}
\value{
Output is a 'Word' document with:
\itemize{
\item A correlation plot (\code{output_file}).
\item A legend (\code{legendname}) if applicable.
}
Using the option "output_type", it can also generate output in the form of: R Markdown code, 'pdf', or 'PNG' files. No value is returned to the R environment; instead, files are saved, and they are opened automatically if running on Windows.
}
\description{
Creates correlation plots for numeric variables in a data frame, optionally incorporating factors for coloring and shaping points. It supports automatic detection of factors, customization of plot aesthetics, and the generation of separate legend files.
}
\details{
\itemize{
\item Factor Detection: If \code{detect_factors} is enabled, up to two factors are automatically detected from the dataset and used for coloring (\code{color_factor}) and shaping (\code{shape_factor}) points in the plot.
\item Customization: Users can manually specify which factors to use by setting \code{color_factor} and/or (\code{shape_factor}). Non-factor variables are converted into factors automatically, with a message indicating this conversion.
\item Legend Generation: A separate legend file is created when factors are used or if \code{print_legend} is explicitly set to \code{TRUE}.
}

The function uses numeric variables in the dataset for scatterplots and computes Pearson correlations displayed in the upper triangle of the correlation matrix.

This function requires [Pandoc](https://github.com/jgm/pandoc/releases/tag) (version 1.12.3 or higher), a universal document converter.
\itemize{
\item \bold{Windows:} Install Pandoc and ensure the installation folder \cr (e.g., "C:/Users/your_username/AppData/Local/Pandoc") is added to your system PATH.
\item \bold{macOS:} If using Homebrew, Pandoc is typically installed in "/usr/local/bin". Alternatively, download the .pkg installer and verify that the binary’s location is in your PATH.
\item \bold{Linux:} Install Pandoc through your distribution’s package manager (commonly installed in "/usr/bin" or "/usr/local/bin") or manually, and ensure the directory containing Pandoc is in your PATH.

\item If Pandoc is not found, this function may not work as intended.
}
}
\note{
\itemize{
\item At least two numeric variables are required in the dataset; otherwise, an error is thrown.
\item If more than two factors are detected, only the first two are used with a warning message.
}
}
\examples{
# Example usage:
data("mtcars")

mtcars_sub <- subset(mtcars, select = -c(am, qsec, vs))
# Customizing factors:
f_corplot(mtcars_sub,
           shape_factor = "cyl",
           color_factor = "gear",
           output_type = "png",
           open_generated_files = FALSE
           )


# Output to MS Word and add fancy column names, only adjusting two of the four variable names.
data(iris)
fancy_names <- c(Sepal.Length = "Sepal Length (cm)", Sepal.Width = "Sepal Width (cm)")
f_corplot(iris,
           fancy_names = fancy_names,
           output_type = "word",
           open_generated_files = FALSE
           )


}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
