/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.stream.Stream;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.EvtScheduler;

public interface Variable
extends Identity,
Comparable<Variable> {
    public static final int VAR = 1;
    public static final int CSTE = 2;
    public static final int VIEW = 4;
    public static final int TYPE = 7;
    public static final int INT = 8;
    public static final int BOOL = 24;
    public static final int SET = 32;
    public static final int REAL = 64;
    public static final int GRAPH = 128;
    public static final int KIND = 1016;

    public boolean isInstantiated();

    public int getDomainSize();

    public int instantiationWorldIndex();

    public void recordWorldIndex();

    public String getName();

    @Deprecated
    public Propagator<?>[] getPropagators();

    @Deprecated
    public Propagator<?> getPropagator(int var1);

    public Stream<Propagator<?>> streamPropagators();

    public int getNbProps();

    @Deprecated
    public int[] getPIndices();

    @Deprecated
    public void setPIndice(int var1, int var2);

    @Deprecated
    public int getDindex(int var1);

    public int getIndexInPropagator(int var1);

    public void addMonitor(IVariableMonitor<?> var1);

    public void removeMonitor(IVariableMonitor<?> var1);

    public void subscribeView(IView<?> var1, int var2);

    public IDelta getDelta();

    public void createDelta();

    public void link(Propagator<?> var1, int var2);

    public void swapOnPassivate(Propagator<?> var1, int var2);

    @Deprecated
    public int swapOnActivate(Propagator<?> var1, int var2);

    public void unlink(Propagator<?> var1, int var2);

    public void notifyPropagators(IEventType var1, ICause var2) throws ContradictionException;

    public void notifyViews(IEventType var1, ICause var2) throws ContradictionException;

    public int getNbViews();

    public IView<?> getView(int var1);

    public void notifyMonitors(IEventType var1) throws ContradictionException;

    public void contradiction(ICause var1, String var2) throws ContradictionException;

    public Model getModel();

    default public IEnvironment getEnvironment() {
        return this.getModel().getEnvironment();
    }

    public int getTypeAndKind();

    public boolean isAConstant();

    public EvtScheduler<?> getEvtScheduler();

    public boolean isScheduled();

    public void schedule();

    public void unschedule();

    public void schedulePropagators(PropagationEngine var1);

    public IntVar asIntVar();

    public BoolVar asBoolVar();

    public RealVar asRealVar();

    public SetVar asSetVar();

    public void storeEvents(int var1, ICause var2);

    public void clearEvents();

    public int getMask();

    public ICause getCause();
}

