% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate data}
\usage{
sim_data(n = 500, p = 10, rho = 0.6, predictor_dist = "correlated",
  mean_function = "nonlinear-interaction",
  error_dist = "homoscedastic")
}
\arguments{
\item{n}{Sample size}

\item{p}{Number of features}

\item{rho}{Correlation between predictors}

\item{predictor_dist}{Distribution of predictor: "uncorrelated", and "correlated"}

\item{mean_function}{Mean function: "linear", "nonlinear", and "nonlinear-interaction"}

\item{error_dist}{Distribution of error: "homoscedastic", "heteroscedastic", and "heavy-tailed"}
}
\value{
a data.frame of simulated data
}
\description{
Simulate data for illustrate the performance of prediction intervals for random forests
}
\examples{
\donttest{
train_data <- sim_data(n = 500, p = 10)
test_data <- sim_data(n = 500, p = 10)
}
}
