% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exam.R
\name{exam}
\alias{exam}
\title{`exam` S3 class}
\usage{
exam(
  rmd = NULL,
  examinees = NULL,
  instances_num = 1,
  random = TRUE,
  reorder_exercises = TRUE,
  select_n_exercises = NULL
)
}
\arguments{
\item{rmd}{A string representing the path to the Rmd file, the exam template.}

\item{examinees}{A vector of strings, representing the names of instances to
generate.}

\item{instances_num}{An integer, representing the number of instances to generate
if the examinee names are not provided.}

\item{random}{A boolean, indicating whether to generate instances randomly or
sequentially.}

\item{reorder_exercises}{A boolean, indicating whether to reorder exercises in
the exam.}

\item{select_n_exercises}{An integer, representing the number of exercises to
include.}
}
\value{
An `exam` object.
}
\description{
Creates an `exam` object.
}
\details{
A test is based on an Rmd template that has predefined parameters whose values
are filled in using the functions of this object. In the `rmd` parameter, we
specify the template file.

From the template, we generate multiple instances of the exam. We can specify
the instances to generate in two ways: by indicating a vector of examinee names
(using the `examinees` parameter) or by specifying the number of instances to
generate (using the `instances_num` parameter). If both are indicated, the
examinee names take precedence.

We can generate the instances either randomly or sequentially, depending on the
instance number we generate. This is controlled by the `random` parameter.

Additionally, in each test, we can include the exercises in the same order as
they are defined or in random order. This is indicated by the `reorder_exercises`
parameter.

Finally, using the `select_n_exercises` parameter, we can specify the number
of exercises to include in each test. From all available exercises, the quantity
specified in this parameter will be randomly selected. By default, all defined
exercises are included.
}
\examples{

rmd <- system.file("extdata/template01.Rmd", package = "rexer")
ex <- exam(
  rmd = rmd,
  examinees = NULL,
  instances_num = 10,
  random = TRUE,
  reorder_exercises = TRUE,
  select_n_exercises = NULL
)

}
\seealso{
\code{\link{define_an_exercise}}

Other exam definition: 
\code{\link{generate_correction_document}()},
\code{\link{generate_document}()}
}
\concept{exam definition}
