% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_raw_data_files.R
\name{get_raw_data_files}
\alias{get_raw_data_files}
\title{Get Raw Data Files}
\usage{
get_raw_data_files(rev_product_ids, days_back)
}
\arguments{
\item{rev_product_ids}{A vector of Revenera product id's for which
you want active user data.}

\item{days_back}{How many days back to go to generate download URLs. Limiting
this, if not all files are needed, will significantly reduce execution time.}
}
\value{
Data frame with available files and URLs.
}
\description{
Retrieves a list of raw data file exports that are available for a
list of product IDs and the download URL for each file.
}
\details{
Raw data files are an add-on service available through Revenera. If
these files are available they can be downloaded manually from the
user portal, or downloaded via R. This function uses the API to
first retrieve the list of files, and then get the download URL for
each file.

It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more
secure; this package does not require you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
logout(rev_user, rev_pwd)
Sys.sleep(30)
revenera_auth(rev_user, rev_pwd)
product_ids_list <- c("123", "456", "789")
urls_df <- get_raw_data_files(product_ids_list, days_back = 3)
urls <- urls_df \%>\% pull(download_url)
file_names <-  urls_df \%>\%   pull(file_name)
file_list <- dplyr::pull(files_df, var = file_name)
dl_and_write <- function(u, f) {
  download.file(u, mode = "wb", destfile = f)
  upload_blob(cont, src = f, dest = paste0("/zip/", f))
  file.remove(f)
}
purrr::map2(urls, file_names, purrr::possibly(dl_and_write, "Download Error"))
}
}
