% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{as_result}
\alias{as_result}
\title{Wraps an expression in \code{result} type, choosing between \code{success}
and \code{failure} based on the outcome of the expression.}
\usage{
as_result(.expr, detect_warning = TRUE, fail_on_warning = TRUE)
}
\arguments{
\item{.expr}{expression to evaluate}

\item{detect_warning}{logical, whether to detect warnings; note
\code{as_result()} cannot capture the outcome of an expression if it
catches warnings, so use \code{detect_warning = TRUE } only if you want
to capture the warning message (e.g., after a side-effect).}

\item{fail_on_warning}{logical, whether to treat warnings as \code{failure}
or \code{success}.}
}
\value{
\code{result} object of subclass \code{success} or \code{failure}
}
\description{
Use \code{as_result} on expressions whose outcomes are not known in advance or not
safe to be examined. The expression will be evualted immediately and wrapped
in \code{success} if it produces a value or \code{failure} if it produces an
error. If the expression produces a warning, it will be wrapped in
\code{success} or \code{failure} depending on the \code{fail_on_warning}
argument.
}
\examples{
as_result(42)
as_result(1 + 1)

stopper <- as_result(stop("This is my error message"))
is_failure(stopper)
value(stopper)

as_result(warning("You've been warned")) |> is_success()
as_result(warning("You've been warned"), fail_on_warning = FALSE) |> value()
}
