% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reslr_input.R
\name{plot.reslr_input}
\alias{plot.reslr_input}
\title{Plot raw data with measurement uncertainty.}
\usage{
\method{plot}{reslr_input}(
  x,
  title = "",
  xlab = "Year (CE)",
  ylab = "Relative Sea Level (m)",
  plot_tide_gauges = FALSE,
  plot_proxy_records = TRUE,
  plot_caption = TRUE,
  ...
)
}
\arguments{
\item{x}{An object created via the function \code{\link{reslr_load}}}

\item{title}{Title of the plot}

\item{xlab}{Labeling the x-axis}

\item{ylab}{Labeling the y-axis}

\item{plot_tide_gauges}{Plotting the tide gauge data with the proxy records}

\item{plot_proxy_records}{Plotting the proxy records on their own and this is the default}

\item{plot_caption}{Plotting an informed caption with the number of tide gauges and proxy sites.}

\item{...}{Not used}
}
\value{
Plot of the raw data with the measurement uncertainty.
}
\description{
In this function, the raw data is plotted with grey uncertainty boxes representing the uncertainty associated with the input and the output.
The function allows the user to plot the proxy record data and tide gauge data together or separately.
}
\examples{
\donttest{
full_dataset <- reslr_load(NAACproxydata)
plot(full_dataset)}
}
