test_that("resizableSplitUI returns correct structure with default settings", {
  ui <- resizableSplitUI(
    id = "test",
    sidebarpane = shiny::div("sidebar"),
    maincontenttop = shiny::div("top"),
    maincontentbottom = shiny::div("bottom")
  )

  # Should return a bootstrapPage (which is a shiny.tag.list) by default
  expect_s3_class(ui, "shiny.tag.list")
})

test_that("resizableSplitUI returns taglist when requested", {
  ui <- resizableSplitUI(
    id = "test",
    sidebarpane = shiny::div("sidebar"),
    maincontenttop = shiny::div("top"),
    maincontentbottom = shiny::div("bottom"),
    return.only.taglist = TRUE
  )

  # Should return a taglist when return.only.taglist = TRUE
  expect_s3_class(ui, "shiny.tag.list")
})

test_that("resizableSplitUI accepts custom percentages", {
  ui <- resizableSplitUI(
    id = "test",
    sidebarpane = shiny::div("sidebar"),
    maincontenttop = shiny::div("top"),
    maincontentbottom = shiny::div("bottom"),
    sidebar.percentage = 20,
    maincontenttop.percentage = 70
  )

  # Should not error with custom percentages
  expect_s3_class(ui, "shiny.tag.list")
})

test_that("resizableSplitUI creates proper namespaced IDs", {
  ui <- resizableSplitUI(
    id = "mymodule",
    sidebarpane = shiny::div("sidebar"),
    maincontenttop = shiny::div("top"),
    maincontentbottom = shiny::div("bottom"),
    return.only.taglist = TRUE
  )

  # Convert to character to check for namespaced IDs
  ui_html <- as.character(ui)

  # Should contain namespaced IDs
  expect_match(ui_html, "mymodule-sidebar")
  expect_match(ui_html, "mymodule-maincontent")
  expect_match(ui_html, "mymodule-maincontenttop")
  expect_match(ui_html, "mymodule-maincontentbottom")
})

test_that("resizableSplitServer runs without error", {
  # Test the server function (even though it's not exported)
  # This ensures it doesn't error when called
  testServer <- resizableSplitLayout:::resizableSplitServer

  expect_no_error({
    shiny::testServer(testServer, {
      # Currently the server function is a placeholder
      # Just verify it can be called without error
    })
  })
})
