% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mobiles}
\alias{mobiles}
\title{Mobiles}
\format{
An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 1916 rows and 11 columns.
}
\source{
\url{https://github.com/openrepair/data/tree/master/quests/mobiles}
}
\usage{
mobiles
}
\description{
Result of two online quests where volunteer participants looked at about 1900 mobile phone repair attempts recorded at community events.
}
\details{
Dataset of printer repair records from the Open Repair Alliance in ORDS format style with added \code{fault_type} values.
Results of \href{https://openrepair.org/open-data/insights/mobiles/}{Results of Open Repair Data quests MobiFix and MobiFix:ORA}.

There are some differences in the structure of this data and any of the ORDS format versions (0.1 and 0.2).
The records involved span different ORDS versions and a handful have not yet been exported.
\enumerate{
\item The usual ORDS id values have been replaced by special mobifix-specific unique identifiers
\item The model field was removed from the ORDS v0.2 standard but was useful for these quests and so has been retained in this dataset
\item Age is an important metric in repair policy, therefore it was derived from and replaced the year_of_manufacture field
\item The field group_identifier is irrelevent in this analysis and thus has been omitted from the dataset
}

\href{https://restarters.net/mobifix/status}{MobiFix} was held in July 2020 using data from ORA partner The Restart Project.
\href{https://restarters.net/mobifixora/status}{MobiFix:ORA} was held in March 2021 using data from ORA partners anstiftung and Repair Café International.
\describe{
\item{id}{ID.}
\item{data_provider}{Data provider. Option from ORDS codelist. Name of partner organisation.}
\item{country}{Country. Three letter
\href{https://github.com/openrepair/data/blob/master/tools/iso_country_codes/iso_country_codes.csv}{ISO code},
e.g. “GBR”.}
\item{fault_type}{Fault type.}
\item{product_category}{Product category. Option from ORDS
\href{https://standard.openrepair.org/standard.html#ords-product-category-values}{product category codelist}.}
\item{brand}{Brand.}
\item{model}{Product model.}
\item{repair_status}{Result of the repair attempt.}
\item{age}{Product age.}
\item{event_date}{Event date. The date of the repair event that the repair took place at.}
\item{problem}{Problem description.}
}
}
\keyword{datasets}
