% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioned-GLS.R
\name{crosspart_GLS}
\alias{crosspart_GLS}
\title{Calculate cross-partition statistics in a partitioned GLS}
\usage{
crosspart_GLS(
  xxi,
  xxj,
  xxi0,
  xxj0,
  invChol_i,
  invChol_j,
  Vsub,
  nug_i,
  nug_j,
  df1,
  df2,
  small = TRUE,
  ncores = NA
)
}
\arguments{
\item{xxi}{numeric matrix xx from  partition i}

\item{xxj}{numeric matrix xx from  partition j}

\item{xxi0}{numeric matrix xx0 from  partition i}

\item{xxj0}{numeric matrix xx0 from  partition j}

\item{invChol_i}{numeric matrix invcholV from  partition i}

\item{invChol_j}{numeric matrix invcholV from  partition j}

\item{Vsub}{numeric variance matrix for Xij (upper block)}

\item{nug_i}{nugget from partition i}

\item{nug_j}{nugget from partition j}

\item{df1}{first degree of freedom}

\item{df2}{second degree of freedom}

\item{small}{logical: if \code{TRUE}, only return \code{rcoefij}, \code{rSSRij},
and \code{rSSEij}}

\item{ncores}{an optional integer indicating how many CPU threads to use for
matrix calculations.}
}
\value{
\code{crosspart_GLS} returns a list of cross-partition statistics.

If \code{small = FALSE}, the list contains the following elements

\describe{
    \item{Rij}{}
    \item{Hi}{}
    \item{Hj}{}
    \item{Hi0}{}
    \item{Hj0}{}
    \item{SiR}{}
    \item{SjR}{}
    \item{rcoefij}{}
    \item{rSSRij}{}
    \item{rSSEij}{}
    \item{Vcoefij}{}
}

If \code{small = FALSE}, the list only contains the necessary elements
\code{rcoefij}, \code{rSSRij}, and \code{rSSEij}.
}
\description{
Calculate cross-partition statistics between two GLS partitions
}
\seealso{
Other partitionedGLS: 
\code{\link{MC_GLSpart}()},
\code{\link{sample_partitions}()}
}
\concept{partitionedGLS}
